/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.database.search;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.SortedSet;
import java.util.TreeSet;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.database.search.ForeignKeyRelationshipEdge;
import org.dbunit.util.search.AbstractNodesFilterSearchCallback;
import org.dbunit.util.search.IEdge;
import org.dbunit.util.search.SearchException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMetaDataBasedSearchCallback
extends AbstractNodesFilterSearchCallback {
    private static final Logger logger = LoggerFactory.getLogger((Class)(class$org$dbunit$database$search$AbstractMetaDataBasedSearchCallback == null ? (class$org$dbunit$database$search$AbstractMetaDataBasedSearchCallback = AbstractMetaDataBasedSearchCallback.class$("org.dbunit.database.search.AbstractMetaDataBasedSearchCallback")) : class$org$dbunit$database$search$AbstractMetaDataBasedSearchCallback));
    private final IDatabaseConnection connection;
    protected static final int IMPORT = 0;
    protected static final int EXPORT = 1;
    protected static final int[] TABLENAME_INDEXES = new int[]{3, 7};
    protected static final int[] PK_INDEXES = new int[]{4, 4};
    protected static final int[] FK_INDEXES = new int[]{8, 8};
    static /* synthetic */ Class class$org$dbunit$database$search$AbstractMetaDataBasedSearchCallback;

    public AbstractMetaDataBasedSearchCallback(IDatabaseConnection connection) {
        this.connection = connection;
    }

    public IDatabaseConnection getConnection() {
        logger.debug("getConnection() - start");
        return this.connection;
    }

    protected SortedSet getNodesFromImportedKeys(Object node) throws SearchException {
        logger.debug("getNodesFromImportedKeys(node=" + node + ") - start");
        return this.getNodes(0, node);
    }

    protected SortedSet getNodesFromExportedKeys(Object node) throws SearchException {
        logger.debug("getNodesFromExportedKeys(node=" + node + ") - start");
        return this.getNodes(1, node);
    }

    protected SortedSet getNodesFromImportAndExportKeys(Object node) throws SearchException {
        logger.debug("getNodesFromImportAndExportKeys(node=" + node + ") - start");
        SortedSet importedNodes = this.getNodesFromImportedKeys(node);
        SortedSet exportedNodes = this.getNodesFromExportedKeys(node);
        importedNodes.addAll(exportedNodes);
        return importedNodes;
    }

    private SortedSet getNodes(int type, Object node) throws SearchException {
        logger.debug("getNodes(type=" + type + ", node=" + node + ") - start");
        try {
            Connection conn = this.connection.getConnection();
            String schema = this.connection.getSchema();
            DatabaseMetaData metaData = conn.getMetaData();
            TreeSet edges = new TreeSet();
            this.getNodes(type, node, conn, schema, metaData, edges);
            return edges;
        }
        catch (SQLException e) {
            logger.error("getNodes()", (Throwable)e);
            throw new SearchException(e);
        }
    }

    private void getNodes(int type, Object node, Connection conn, String schema, DatabaseMetaData metaData, SortedSet edges) throws SearchException {
        logger.debug("getNodes(type=" + type + ", node=" + node + ", conn=" + conn + ", schema=" + schema + ", metaData=" + metaData + ", edges=" + edges + ") - start");
        if (logger.isDebugEnabled()) {
            logger.debug("Getting edges for node " + node);
        }
        try {
            if (!(node instanceof String)) {
                throw new IllegalArgumentException("node should be a String, not a " + node.getClass().getName());
            }
            String tableName = (String)node;
            ResultSet rs = null;
            switch (type) {
                case 0: {
                    rs = metaData.getImportedKeys(null, schema, tableName);
                    break;
                }
                case 1: {
                    rs = metaData.getExportedKeys(null, schema, tableName);
                }
            }
            while (rs.next()) {
                int index = TABLENAME_INDEXES[type];
                String dependentTableName = rs.getString(index);
                String pkColumn = rs.getString(PK_INDEXES[type]);
                String fkColumn = rs.getString(FK_INDEXES[type]);
                IEdge edge = this.newEdge(rs, type, tableName, dependentTableName, fkColumn, pkColumn);
                if (logger.isDebugEnabled()) {
                    logger.debug("Adding edge " + edge);
                }
                edges.add(edge);
            }
        }
        catch (SQLException e) {
            logger.error("getNodes()", (Throwable)e);
            throw new SearchException(e);
        }
    }

    protected static ForeignKeyRelationshipEdge createFKEdge(ResultSet rs, int type, String from, String to, String fkColumn, String pkColumn) throws SearchException {
        logger.debug("createFKEdge(rs=" + rs + ", type=" + type + ", from=" + from + ", to=" + to + ", fkColumn=" + fkColumn + ", pkColumn=" + pkColumn + ") - start");
        return type == 0 ? new ForeignKeyRelationshipEdge(from, to, fkColumn, pkColumn) : new ForeignKeyRelationshipEdge(to, from, fkColumn, pkColumn);
    }

    protected IEdge newEdge(ResultSet rs, int type, String from, String to, String fkColumn, String pkColumn) throws SearchException {
        logger.debug("newEdge(rs=" + rs + ", type=" + type + ", from=" + from + ", to=" + to + ", fkColumn=" + fkColumn + ", pkColumn=" + pkColumn + ") - start");
        return AbstractMetaDataBasedSearchCallback.createFKEdge(rs, type, from, to, fkColumn, pkColumn);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

