/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.weblogic.internal;

import java.util.Iterator;
import org.codehaus.cargo.container.configuration.entry.DataSource;
import org.codehaus.cargo.container.property.TransactionSupport;
import org.codehaus.cargo.container.weblogic.internal.WebLogic8xConfigurationBuilder;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class WebLogic9x10xAnd103xConfigurationBuilder
extends WebLogic8xConfigurationBuilder {
    public WebLogic9x10xAnd103xConfigurationBuilder(String serverName) {
        super(serverName);
    }

    protected String configureDataSourceWithImplementationClass(DataSource ds, String className) {
        Element nameElement = DocumentHelper.createDocument().addElement("name");
        nameElement.setText(ds.getId());
        Element driverElement = DocumentHelper.createDocument().addElement("jdbc-driver-params");
        if (ds.getUrl() != null) {
            driverElement.addElement("url").setText(ds.getUrl());
        }
        driverElement.addElement("driver-name").setText(className);
        Element properties = driverElement.addElement("properties");
        ds.getConnectionProperties().setProperty("user", ds.getUsername());
        Iterator<Object> driverProperties = ds.getConnectionProperties().keySet().iterator();
        while (driverProperties.hasNext()) {
            String name = driverProperties.next().toString();
            String value = ds.getConnectionProperties().getProperty(name);
            Element property = properties.addElement("property");
            property.addElement("name").setText(name);
            property.addElement("value").setText(value);
        }
        Element dataSourceElement = DocumentHelper.createDocument().addElement("jdbc-data-source-params");
        dataSourceElement.addElement("jndi-name").setText(ds.getJndiLocation());
        if (ds.getConnectionType().equals("javax.sql.XADataSource")) {
            dataSourceElement.addElement("global-transactions-protocol").setText("TwoPhaseCommit");
        } else if (ds.getTransactionSupport().equals((Object)TransactionSupport.XA_TRANSACTION)) {
            dataSourceElement.addElement("global-transactions-protocol").setText("EmulateTwoPhaseCommit");
        } else {
            dataSourceElement.addElement("global-transactions-protocol").setText("None");
        }
        StringBuffer out = new StringBuffer();
        out.append(nameElement.asXML());
        out.append("\n");
        out.append(driverElement.asXML());
        out.append("\n");
        out.append(dataSourceElement.asXML());
        return out.toString();
    }
}

