/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.weblogic.internal;

import org.codehaus.cargo.container.configuration.entry.DataSource;
import org.codehaus.cargo.container.configuration.entry.Resource;
import org.codehaus.cargo.container.property.DataSourceConverter;
import org.codehaus.cargo.container.property.TransactionSupport;
import org.codehaus.cargo.container.spi.configuration.builder.AbstractConfigurationBuilder;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class WebLogic8xConfigurationBuilder
extends AbstractConfigurationBuilder {
    public static final String RESOURCE_CONFIGURATION_UNSUPPORTED = "WebLogic does not support configuration of arbitrary resources into the JNDI tree.";
    private String serverName;

    public WebLogic8xConfigurationBuilder(String serverName) {
        this.setServerName(serverName);
    }

    protected String configureDataSourceWithImplementationClass(DataSource ds, String className) {
        Element connectionPool = DocumentHelper.createDocument().addElement("JDBCConnectionPool");
        connectionPool.addAttribute("Name", ds.getJndiLocation());
        connectionPool.addAttribute("Targets", this.getServerName());
        if (ds.getUrl() != null) {
            connectionPool.addAttribute("URL", ds.getUrl());
        }
        connectionPool.addAttribute("DriverName", className);
        connectionPool.addAttribute("Password", ds.getPassword());
        ds.getConnectionProperties().setProperty("user", ds.getUsername());
        connectionPool.addAttribute("Properties", new DataSourceConverter().getConnectionPropertiesAsASemicolonDelimitedString(ds));
        Element dataSource = null;
        dataSource = ds.getTransactionSupport().equals((Object)TransactionSupport.NO_TRANSACTION) ? DocumentHelper.createDocument().addElement("JDBCDataSource") : DocumentHelper.createDocument().addElement("JDBCTxDataSource");
        if (ds.getTransactionSupport().equals((Object)TransactionSupport.XA_TRANSACTION) && ds.getDriverClass() != null) {
            dataSource.addAttribute("EnableTwoPhaseCommit", "true");
        }
        dataSource.addAttribute("Name", ds.getJndiLocation());
        dataSource.addAttribute("PoolName", ds.getJndiLocation());
        dataSource.addAttribute("JNDIName", ds.getJndiLocation());
        dataSource.addAttribute("Targets", this.getServerName());
        StringBuffer out = new StringBuffer();
        out.append(connectionPool.asXML());
        out.append("\n");
        out.append(dataSource.asXML());
        return out.toString();
    }

    public String buildEntryForDriverConfiguredDataSourceWithLocalTx(DataSource ds) {
        return this.configureDataSourceWithImplementationClass(ds, ds.getDriverClass());
    }

    public String buildEntryForDriverConfiguredDataSourceWithNoTx(DataSource ds) {
        return this.configureDataSourceWithImplementationClass(ds, ds.getDriverClass());
    }

    public String buildEntryForDriverConfiguredDataSourceWithXaTx(DataSource ds) {
        return this.configureDataSourceWithImplementationClass(ds, ds.getDriverClass());
    }

    public String buildConfigurationEntryForXADataSourceConfiguredDataSource(DataSource ds) {
        return this.configureDataSourceWithImplementationClass(ds, ds.getDriverClass());
    }

    protected void setServerName(String serverName) {
        this.serverName = serverName;
    }

    protected String getServerName() {
        return this.serverName;
    }

    public String toConfigurationEntry(Resource resource) {
        throw new UnsupportedOperationException(RESOURCE_CONFIGURATION_UNSUPPORTED);
    }
}

