/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.tomcat.internal;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.StringTokenizer;
import org.codehaus.cargo.container.tomcat.internal.TomcatDeployableStatus;
import org.codehaus.cargo.container.tomcat.internal.TomcatManagerException;
import org.codehaus.cargo.util.Base64;
import org.codehaus.cargo.util.log.LoggedObject;

public class TomcatManager
extends LoggedObject {
    private static final String MANAGER_CHARSET = "UTF-8";
    private URL url;
    private String username;
    private String password;
    private String charset;
    private String userAgent;

    public TomcatManager(URL url) {
        this(url, "admin");
    }

    public TomcatManager(URL url, String username) {
        this(url, username, "");
    }

    public TomcatManager(URL url, String username, String password) {
        this(url, username, password, "ISO-8859-1");
    }

    public TomcatManager(URL url, String username, String password, String charset) {
        this.url = url;
        this.username = username;
        this.password = password;
        this.charset = charset;
    }

    public URL getURL() {
        return this.url;
    }

    public String getUserName() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getCharset() {
        return this.charset;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public void deploy(String path, URL war) throws TomcatManagerException, IOException {
        this.deploy(path, war, false);
    }

    public void deploy(String path, URL war, boolean update) throws TomcatManagerException, IOException {
        this.deploy(path, war, update, null);
    }

    public void deploy(String path, URL war, boolean update, String tag) throws TomcatManagerException, IOException {
        this.deployImpl(path, null, war, null, update, tag);
    }

    public void deploy(String path, InputStream war) throws TomcatManagerException, IOException {
        this.deploy(path, war, false);
    }

    public void deploy(String path, InputStream war, boolean update) throws TomcatManagerException, IOException {
        this.deploy(path, war, update, null);
    }

    public void deploy(String path, InputStream war, boolean update, String tag) throws TomcatManagerException, IOException {
        this.deployImpl(path, null, null, war, update, tag);
    }

    public void deployContext(String path, URL config) throws TomcatManagerException, IOException {
        this.deployContext(path, config, false);
    }

    public void deployContext(String path, URL config, boolean update) throws TomcatManagerException, IOException {
        this.deployContext(path, config, update, null);
    }

    public void deployContext(String path, URL config, boolean update, String tag) throws TomcatManagerException, IOException {
        this.deployContext(path, config, null, update, tag);
    }

    public void deployContext(String path, URL config, URL war) throws TomcatManagerException, IOException {
        this.deployContext(path, config, war, false);
    }

    public void deployContext(String path, URL config, URL war, boolean update) throws TomcatManagerException, IOException {
        this.deployContext(path, config, war, update, null);
    }

    public void deployContext(String path, URL config, URL war, boolean update, String tag) throws TomcatManagerException, IOException {
        this.deployImpl(path, config, war, null, update, tag);
    }

    public void undeploy(String path) throws TomcatManagerException, IOException {
        this.invoke("/undeploy?path=" + URLEncoder.encode(path, this.charset));
    }

    public void remove(String path) throws TomcatManagerException, IOException {
        this.invoke("/remove?path=" + URLEncoder.encode(path, this.charset));
    }

    public void reload(String path) throws TomcatManagerException, IOException {
        this.invoke("/reload?path=" + URLEncoder.encode(path, this.charset));
    }

    public void start(String path) throws TomcatManagerException, IOException {
        this.invoke("/start?path=" + URLEncoder.encode(path, this.charset));
    }

    public void stop(String path) throws TomcatManagerException, IOException {
        this.invoke("/stop?path=" + URLEncoder.encode(path, this.charset));
    }

    protected void invoke(String path) throws TomcatManagerException, IOException {
        this.invoke(path, null);
    }

    protected String invoke(String path, InputStream data) throws TomcatManagerException, IOException {
        String response;
        this.getLogger().debug("Invoking Tomcat manager using path [" + path + "]", ((Object)((Object)this)).getClass().getName());
        URL invokeURL = new URL(this.url + path);
        HttpURLConnection connection = (HttpURLConnection)invokeURL.openConnection();
        connection.setAllowUserInteraction(false);
        connection.setDoInput(true);
        connection.setUseCaches(false);
        if (data == null) {
            connection.setDoOutput(false);
            connection.setRequestMethod("GET");
        } else {
            connection.setDoOutput(true);
            connection.setRequestMethod("PUT");
            connection.setRequestProperty("Content-Type", "application/octet-stream");
            try {
                connection.getClass().getMethod("setChunkedStreamingMode", Integer.TYPE).invoke((Object)connection, new Integer(0));
            }
            catch (Exception e) {
                this.getLogger().debug("Not calling setChunkedStreamingMode() method as JVM [" + System.getProperty("java.version") + "] doesn't support it.", ((Object)((Object)this)).getClass().getName());
            }
        }
        if (this.userAgent != null) {
            connection.setRequestProperty("User-Agent", this.userAgent);
        }
        if (this.username != null) {
            String authorization = TomcatManager.toAuthorization(this.username, this.password);
            connection.setRequestProperty("Authorization", authorization);
        }
        connection.connect();
        if (data != null) {
            this.pipe(data, connection.getOutputStream());
        }
        if (!(response = this.toString(connection.getInputStream(), MANAGER_CHARSET)).startsWith("OK -")) {
            throw new TomcatManagerException(response);
        }
        return response;
    }

    private void deployImpl(String path, URL config, URL war, InputStream data, boolean update, String tag) throws TomcatManagerException, IOException {
        StringBuffer buffer = new StringBuffer("/deploy");
        buffer.append("?path=").append(URLEncoder.encode(path, this.charset));
        if (config != null) {
            buffer.append("&config=").append(URLEncoder.encode(config.toString(), this.charset));
        }
        if (war != null) {
            buffer.append("&war=").append(URLEncoder.encode(war.toString(), this.charset));
        }
        if (update) {
            buffer.append("&update=true");
        }
        if (tag != null) {
            buffer.append("&tag=").append(URLEncoder.encode(tag, this.charset));
        }
        this.invoke(buffer.toString(), data);
    }

    private static String toAuthorization(String username, String password) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(username).append(':');
        if (password != null) {
            buffer.append(password);
        }
        return "Basic " + new String(Base64.encodeBase64((byte[])buffer.toString().getBytes()));
    }

    private void pipe(InputStream in, OutputStream out) throws IOException {
        int n;
        BufferedOutputStream bufferedOut = new BufferedOutputStream(out);
        byte[] bytes = new byte[4096];
        while ((n = in.read(bytes)) != -1) {
            bufferedOut.write(bytes, 0, n);
        }
        bufferedOut.flush();
        bufferedOut.close();
        in.close();
    }

    private String toString(InputStream in, String charset) throws IOException {
        int n;
        InputStreamReader reader = new InputStreamReader(in, charset);
        StringBuffer buffer = new StringBuffer();
        char[] chars = new char[1024];
        while ((n = reader.read(chars, 0, chars.length)) != -1) {
            buffer.append(chars, 0, n);
        }
        return buffer.toString();
    }

    public String list() throws IOException, TomcatManagerException {
        return this.invoke("/list", null);
    }

    public TomcatDeployableStatus getStatus(String path) throws IOException, TomcatManagerException {
        StringTokenizer records = new StringTokenizer(this.list(), "\n");
        while (records.hasMoreTokens()) {
            String record = records.nextToken();
            StringTokenizer words = new StringTokenizer(record, ":");
            while (words.hasMoreTokens()) {
                String str = words.nextToken();
                if (!path.equals(str)) continue;
                String token = words.nextToken();
                return TomcatDeployableStatus.toStatus(token);
            }
        }
        return TomcatDeployableStatus.NOT_FOUND;
    }
}

