/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.tomcat.internal;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import org.codehaus.cargo.container.ContainerException;

public final class Tomcat5xEmbedded {
    private Constructor embeddedNew;
    private Method embeddedCreateEngine;
    private Method embeddedCreateHost;
    private Method embeddedStart;
    private Method embeddedStop;
    private Method embeddedAddEngine;
    private Method embeddedCreateConnector;
    private Method embeddedAddConnector;
    private Method embeddedCreateContext;
    private Method embeddedSetRealm;
    private Method embeddedSetCatalinaBase;
    private Method embeddedSetCatalinaHome;
    private Method engineSetName;
    private Method engineAddChild;
    private Method engineSetDefaultHost;
    private Method engineSetParentClassLoader;
    private Method standardEngineSetBaseDir;
    private Method contextReload;
    private Method contextSetAvailable;
    private Method contextAddParameter;
    private Method hostSetAutoDeploy;
    private Method hostGetName;
    private Method hostAddChild;
    private Method hostRemoveChild;
    private Constructor memoryRealmNew;
    private Method memoryRealmSetPathname;
    private final ClassLoader classLoader;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tomcat5xEmbedded(ClassLoader classLoader) throws Exception {
        this.classLoader = classLoader;
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(classLoader);
            this.preloadEngine(classLoader);
            this.preloadMemoryRealm(classLoader);
            this.preloadEmbedded(classLoader);
            this.preloadContext(classLoader);
            this.preloadHost(classLoader);
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    private void preloadEngine(ClassLoader classLoader) throws Exception {
        Class<?> engine = Class.forName("org.apache.catalina.Engine", true, classLoader);
        Class<?> container = Class.forName("org.apache.catalina.Container", true, classLoader);
        this.engineSetName = engine.getMethod("setName", String.class);
        this.engineAddChild = engine.getMethod("addChild", container);
        this.engineSetDefaultHost = engine.getMethod("setDefaultHost", String.class);
        this.engineSetParentClassLoader = engine.getMethod("setParentClassLoader", ClassLoader.class);
        Class<?> standardEngine = Class.forName("org.apache.catalina.core.StandardEngine", true, classLoader);
        this.standardEngineSetBaseDir = standardEngine.getMethod("setBaseDir", String.class);
    }

    private void preloadMemoryRealm(ClassLoader classLoader) throws Exception {
        Class<?> memoryRealm = Class.forName("org.apache.catalina.realm.MemoryRealm", true, classLoader);
        this.memoryRealmNew = memoryRealm.getConstructor(new Class[0]);
        this.memoryRealmSetPathname = memoryRealm.getMethod("setPathname", String.class);
    }

    private void preloadContext(ClassLoader classLoader) throws Exception {
        Class<?> context = Class.forName("org.apache.catalina.Context", true, classLoader);
        this.contextReload = context.getMethod("reload", new Class[0]);
        this.contextSetAvailable = context.getMethod("setAvailable", Boolean.TYPE);
        this.contextAddParameter = context.getMethod("addParameter", String.class, String.class);
    }

    private void preloadHost(ClassLoader classLoader) throws Exception {
        Class<?> container = Class.forName("org.apache.catalina.Container", true, classLoader);
        Class<?> host = Class.forName("org.apache.catalina.Host", true, classLoader);
        this.hostSetAutoDeploy = host.getMethod("setAutoDeploy", Boolean.TYPE);
        this.hostGetName = host.getMethod("getName", new Class[0]);
        this.hostAddChild = host.getMethod("addChild", container);
        this.hostRemoveChild = host.getMethod("removeChild", container);
    }

    private void preloadEmbedded(ClassLoader classLoader) throws Exception {
        Class<?> connector;
        Class<?> embedded = Class.forName("org.apache.catalina.startup.Embedded", true, classLoader);
        Class<?> realm = Class.forName("org.apache.catalina.Realm", true, classLoader);
        try {
            connector = Class.forName("org.apache.catalina.Connector", true, classLoader);
        }
        catch (ClassNotFoundException e) {
            connector = Class.forName("org.apache.catalina.connector.Connector", true, classLoader);
        }
        Class<?> engine = Class.forName("org.apache.catalina.Engine", true, classLoader);
        this.embeddedNew = embedded.getConstructor(new Class[0]);
        this.embeddedCreateEngine = embedded.getMethod("createEngine", new Class[0]);
        this.embeddedCreateHost = embedded.getMethod("createHost", String.class, String.class);
        this.embeddedStart = embedded.getMethod("start", new Class[0]);
        this.embeddedStop = embedded.getMethod("stop", new Class[0]);
        this.embeddedAddEngine = embedded.getMethod("addEngine", engine);
        this.embeddedCreateConnector = embedded.getMethod("createConnector", InetAddress.class, Integer.TYPE, Boolean.TYPE);
        this.embeddedAddConnector = embedded.getMethod("addConnector", connector);
        this.embeddedCreateContext = embedded.getMethod("createContext", String.class, String.class);
        this.embeddedSetRealm = embedded.getMethod("setRealm", realm);
        this.embeddedSetCatalinaBase = embedded.getMethod("setCatalinaBase", String.class);
        this.embeddedSetCatalinaHome = embedded.getMethod("setCatalinaHome", String.class);
    }

    private Object newInstance(Constructor c) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.classLoader);
        try {
            Object t = c.newInstance(new Object[0]);
            return t;
        }
        catch (InstantiationException e) {
            throw new ContainerException("Tomcat reported an error: " + e.getMessage(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new ContainerException("Tomcat reported an error: " + e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ContainerException("Tomcat reported an error: " + e.getMessage(), (Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    public final class MemoryRealm
    extends Wrapper {
        public MemoryRealm() {
            super(Tomcat5xEmbedded.this.newInstance(Tomcat5xEmbedded.this.memoryRealmNew));
        }

        public void setPathname(File path) {
            this.invoke(Tomcat5xEmbedded.this.memoryRealmSetPathname, path.toString());
        }
    }

    public final class Engine
    extends Wrapper {
        public Engine(Object core) {
            super(core);
        }

        public void setName(String name) {
            this.invoke(Tomcat5xEmbedded.this.engineSetName, name);
        }

        public void setBaseDir(String baseDir) {
            this.invoke(Tomcat5xEmbedded.this.standardEngineSetBaseDir, baseDir);
        }

        public void addChild(Host host) {
            this.invoke(Tomcat5xEmbedded.this.engineAddChild, host);
        }

        public void setDefaultHost(String name) {
            this.invoke(Tomcat5xEmbedded.this.engineSetDefaultHost, name);
        }

        public void setParentClassLoader(ClassLoader cl) {
            this.invoke(Tomcat5xEmbedded.this.engineSetParentClassLoader, cl);
        }
    }

    public final class Connector
    extends Wrapper {
        public Connector(Object core) {
            super(core);
        }
    }

    public final class Embedded
    extends Wrapper {
        public Embedded() {
            super(Tomcat5xEmbedded.this.newInstance(Tomcat5xEmbedded.this.embeddedNew));
        }

        public Engine createEngine() {
            return new Engine(this.invoke(Tomcat5xEmbedded.this.embeddedCreateEngine));
        }

        public Host createHost(String name, File appBase) {
            return new Host(this.invoke(Tomcat5xEmbedded.this.embeddedCreateHost, name, appBase.getAbsolutePath()));
        }

        public void start() {
            this.invoke(Tomcat5xEmbedded.this.embeddedStart);
        }

        public void stop() {
            this.invoke(Tomcat5xEmbedded.this.embeddedStop);
        }

        public void addEngine(Engine e) {
            this.invoke(Tomcat5xEmbedded.this.embeddedAddEngine, e);
        }

        public Connector createConnector(InetAddress inetAddress, int port, boolean secure) {
            return new Connector(this.invoke(Tomcat5xEmbedded.this.embeddedCreateConnector, inetAddress, new Integer(port), secure));
        }

        public void addConnector(Connector connector) {
            this.invoke(Tomcat5xEmbedded.this.embeddedAddConnector, connector);
        }

        public Context createContext(String path, String docBase) {
            return new Context(this.invoke(Tomcat5xEmbedded.this.embeddedCreateContext, path, new File(docBase).getAbsolutePath()));
        }

        public void setRealm(MemoryRealm realm) {
            this.invoke(Tomcat5xEmbedded.this.embeddedSetRealm, realm);
        }

        public void setCatalinaBase(File dir) {
            this.invoke(Tomcat5xEmbedded.this.embeddedSetCatalinaBase, dir.getAbsolutePath());
        }

        public void setCatalinaHome(File dir) {
            this.invoke(Tomcat5xEmbedded.this.embeddedSetCatalinaHome, dir.getAbsolutePath());
        }
    }

    public final class Host
    extends Wrapper {
        public Host(Object core) {
            super(core);
        }

        public void setAutoDeploy(boolean b) {
            this.invoke(Tomcat5xEmbedded.this.hostSetAutoDeploy, b);
        }

        public String getName() {
            return (String)this.invoke(Tomcat5xEmbedded.this.hostGetName);
        }

        public void addChild(Context context) {
            this.invoke(Tomcat5xEmbedded.this.hostAddChild, context);
        }

        public void removeChild(Context context) {
            this.invoke(Tomcat5xEmbedded.this.hostRemoveChild, context);
        }
    }

    public final class Context
    extends Wrapper {
        public Context(Object context) {
            super(context);
        }

        public void reload() {
            this.invoke(Tomcat5xEmbedded.this.contextReload);
        }

        public void setAvailable(boolean b) {
            this.invoke(Tomcat5xEmbedded.this.contextSetAvailable, b);
        }

        public void addParameter(String key, String value) {
            this.invoke(Tomcat5xEmbedded.this.contextAddParameter, key, value);
        }
    }

    private class Wrapper {
        protected final Object core;

        public Wrapper(Object core) {
            this.core = core;
        }

        protected Object invoke(Method method) {
            return this.invoke(method, new Object[0]);
        }

        protected Object invoke(Method method, Object arg1) {
            return this.invoke(method, new Object[]{arg1});
        }

        protected Object invoke(Method method, Object arg1, Object arg2) {
            return this.invoke(method, new Object[]{arg1, arg2});
        }

        protected Object invoke(Method method, Object arg1, Object arg2, Object arg3) {
            return this.invoke(method, new Object[]{arg1, arg2, arg3});
        }

        protected Object invoke(Method method, Object[] args) {
            for (int i = 0; i < args.length; ++i) {
                if (!(args[i] instanceof Wrapper)) continue;
                args[i] = ((Wrapper)args[i]).core;
            }
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(Tomcat5xEmbedded.this.classLoader);
            try {
                Object object = method.invoke(this.core, args);
                return object;
            }
            catch (IllegalAccessException e) {
                throw new ContainerException("Tomcat reported an error: " + e.getMessage(), (Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new ContainerException("Tomcat reported an error: " + e.getMessage(), (Throwable)e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(cl);
            }
        }
    }
}

