/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.tomcat.internal;

import java.util.Iterator;
import org.codehaus.cargo.container.configuration.entry.Resource;
import org.codehaus.cargo.container.tomcat.internal.AbstractTomcatConfigurationBuilder;

public class Tomcat4xConfigurationBuilder
extends AbstractTomcatConfigurationBuilder {
    public Tomcat4xConfigurationBuilder() {
        this.typeToFactory.put("javax.sql.DataSource", "org.apache.commons.dbcp.BasicDataSourceFactory");
    }

    public String toConfigurationEntry(Resource resource) {
        Iterator parameterNames;
        StringBuffer buff = new StringBuffer();
        buff.append("<Resource ").append("name=\"").append(resource.getName()).append("\"\n");
        if (resource.getClassName() != null) {
            buff.append("          ").append("type=\"").append(resource.getClassName()).append("\"\n");
        } else {
            buff.append("          ").append("type=\"").append(resource.getType()).append("\"\n");
        }
        buff.append("          ").append("auth=\"").append("Container").append("\"\n");
        buff.append("          ").append("/>\n");
        if (resource.getParameter("factory") == null) {
            resource.setParameter("factory", this.getFactoryClassFor(resource.getType()));
        }
        if ((parameterNames = resource.getParameterNames().iterator()).hasNext()) {
            buff.append("<ResourceParams ").append("name=\"").append(resource.getName()).append("\">\n");
            while (parameterNames.hasNext()) {
                String parameterName = (String)parameterNames.next();
                buff.append("  <parameter>\n  <name>");
                buff.append(parameterName);
                buff.append("</name>\n    <value>");
                buff.append(resource.getParameter(parameterName));
                buff.append("</value>\n  </parameter>\n");
            }
            buff.append("</ResourceParams>\n");
        }
        return buff.toString();
    }

    protected String getDataSourceFactoryClass() {
        return "org.apache.commons.dbcp.BasicDataSourceFactory";
    }
}

