/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.resin.internal;

import java.util.Iterator;
import org.codehaus.cargo.container.configuration.entry.DataSource;
import org.codehaus.cargo.container.configuration.entry.Resource;
import org.codehaus.cargo.container.resin.internal.Resin2xConfigurationBuilder;

public class Resin3xConfigurationBuilder
extends Resin2xConfigurationBuilder {
    protected String toResinConfigurationEntry(DataSource ds) {
        StringBuffer dataSourceString = new StringBuffer();
        dataSourceString.append("<database>\n");
        dataSourceString.append("  <jndi-name>").append(ds.getJndiLocation()).append("</jndi-name>\n");
        if (ds.getConnectionType().equals("javax.sql.XADataSource")) {
            dataSourceString.append("  <xa>true</xa>\n");
        }
        dataSourceString.append("  <driver>").append("\n");
        dataSourceString.append("    <type>").append(ds.getDriverClass()).append("</type>\n");
        if (ds.getUrl() != null) {
            dataSourceString.append("    <url>" + ds.getUrl() + "</url>\n");
        }
        dataSourceString.append("    <user>" + ds.getUsername() + "</user>\n");
        dataSourceString.append("    <password>" + ds.getPassword() + "</password>\n");
        if (ds.getConnectionProperties() != null && ds.getConnectionProperties().size() != 0) {
            Iterator<Object> i = ds.getConnectionProperties().keySet().iterator();
            while (i.hasNext()) {
                String key = i.next().toString();
                dataSourceString.append("    <").append(key);
                dataSourceString.append(">").append(ds.getConnectionProperties().getProperty(key));
                dataSourceString.append("</").append(key).append(">\n");
            }
        }
        dataSourceString.append("  </driver>\n");
        dataSourceString.append("</database>");
        return dataSourceString.toString();
    }

    public String toConfigurationEntry(Resource resource) {
        StringBuffer resourceString = new StringBuffer();
        resourceString.append("<resource>\n      <jndi-name>" + resource.getName() + "</jndi-name>\n");
        if (resource.getClassName() != null) {
            resourceString.append("      <type>" + resource.getClassName() + "</type>\n");
        } else {
            resourceString.append("      <type>" + resource.getType() + "</type>\n");
        }
        Iterator i = resource.getParameterNames().iterator();
        while (i.hasNext()) {
            String key = i.next().toString();
            resourceString.append("    <init ").append(key);
            resourceString.append("=\"").append(resource.getParameter(key));
            resourceString.append("\" />\n");
        }
        resourceString.append("</resource>");
        return resourceString.toString();
    }
}

