/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.resin.internal;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.URL;
import java.net.URLClassLoader;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.codehaus.cargo.container.ContainerCapability;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.internal.AntContainerExecutorThread;
import org.codehaus.cargo.container.internal.ServletContainerCapability;
import org.codehaus.cargo.container.resin.internal.ResinRun;
import org.codehaus.cargo.container.resin.internal.ResinUtil;
import org.codehaus.cargo.container.spi.AbstractInstalledLocalContainer;
import org.codehaus.cargo.container.spi.util.DefaultServerRun;
import org.codehaus.cargo.util.CargoException;

public abstract class AbstractResinInstalledLocalContainer
extends AbstractInstalledLocalContainer {
    private String version;
    private ContainerCapability capability = new ServletContainerCapability();

    public AbstractResinInstalledLocalContainer(LocalConfiguration configuration) {
        super(configuration);
    }

    public ContainerCapability getCapability() {
        return this.capability;
    }

    public void doStart(Java java) throws Exception {
        Path classpath = this.doAction(java);
        java.createArg().setValue("-start");
        java.createArg().setValue("-conf");
        File confDir = new File(this.getConfiguration().getHome(), "conf");
        java.createArg().setFile(new File(confDir, "resin.conf"));
        this.startUpAdditions(java, classpath);
        AntContainerExecutorThread resinRunner = new AntContainerExecutorThread(java);
        resinRunner.start();
    }

    public void doStop(Java java) throws Exception {
        this.doAction(java);
        java.createArg().setValue("-stop");
        AntContainerExecutorThread resinRunner = new AntContainerExecutorThread(java);
        resinRunner.start();
    }

    private Path doAction(Java java) {
        java.addSysproperty(this.getAntUtils().createSysProperty("resin.home", this.getConfiguration().getHome()));
        java.setClassname(ResinRun.class.getName());
        Path classpath = java.createClasspath();
        classpath.createPathElement().setLocation(this.getResourceUtils().getResourceLocation("/" + ResinRun.class.getName().replace('.', '/') + ".class"));
        classpath.createPathElement().setLocation(this.getResourceUtils().getResourceLocation("/" + DefaultServerRun.class.getName().replace('.', '/') + ".class"));
        classpath.createPathElement().setLocation(this.getResourceUtils().getResourceLocation("/" + CargoException.class.getName().replace('.', '/') + ".class"));
        FileSet fileSet = new FileSet();
        fileSet.setDir(new File(this.getHome()));
        fileSet.createInclude().setName("lib/*.jar");
        classpath.addFileset(fileSet);
        return classpath;
    }

    protected abstract void startUpAdditions(Java var1, Path var2) throws FileNotFoundException;

    protected String getVersion(String defaultVersion) {
        String version = this.version;
        if (version == null) {
            try {
                URLClassLoader classloader = new URLClassLoader(new URL[]{new File(this.getHome(), "/lib/resin.jar").toURL()});
                version = new ResinUtil().getResinVersion(classloader);
                this.getLogger().info("Found Resin version [" + version + "]", ((Object)((Object)this)).getClass().getName());
            }
            catch (Exception e) {
                this.getLogger().debug("Failed to get Resin version, Error = [" + e.getMessage() + "]. Using generic version [" + defaultVersion + "]", ((Object)((Object)this)).getClass().getName());
                version = defaultVersion;
            }
        }
        this.version = version;
        return version;
    }
}

