/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.resin;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.tools.ant.types.FilterChain;
import org.codehaus.cargo.container.Container;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.configuration.builder.ConfigurationBuilder;
import org.codehaus.cargo.container.resin.internal.AbstractResinStandaloneLocalConfiguration;
import org.codehaus.cargo.container.resin.internal.Resin3xConfigurationBuilder;

public class Resin3xStandaloneLocalConfiguration
extends AbstractResinStandaloneLocalConfiguration {
    public static final String XML_PARENT_OF_RESOURCES = "//resin:resin";

    public Resin3xStandaloneLocalConfiguration(String dir) {
        super(dir);
    }

    protected ConfigurationBuilder createConfigurationBuilder(LocalContainer container) {
        return new Resin3xConfigurationBuilder();
    }

    protected String getXpathForResourcesParent() {
        return XML_PARENT_OF_RESOURCES;
    }

    protected Map getNamespaces() {
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("resin", "http://caucho.com/ns/resin");
        return namespaces;
    }

    protected void prepareAdditions(Container container, FilterChain theFilterChain) throws IOException {
        this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/" + container.getId() + "/app-default.xml", this.getFileHandler().append(this.getHome(), "app-default.xml"), this.getFileHandler(), this.getFilterChain());
    }

    private String getResinLoggingLevel(String cargoLoggingLevel) {
        String level = cargoLoggingLevel.equalsIgnoreCase("low") ? "severe" : (cargoLoggingLevel.equalsIgnoreCase("medium") ? "warning" : "config");
        return level;
    }

    protected FilterChain createResinFilterChain() {
        FilterChain filterChain = this.getFilterChain();
        this.getAntUtils().addTokenToFilterChain(filterChain, "resin.expanded.webapps", this.createExpandedWarTokenValue("document-directory"));
        this.getAntUtils().addTokenToFilterChain(filterChain, "resin3x.users", this.getSecurityToken("<user>", "</user>"));
        this.getAntUtils().addTokenToFilterChain(filterChain, "resin3x.logging.level", this.getResinLoggingLevel(this.getPropertyValue("cargo.logging")));
        return filterChain;
    }
}

