/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.jonas.internal;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServerConnection;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.j2ee.Management;
import javax.management.j2ee.ManagementHome;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import org.codehaus.cargo.container.configuration.RuntimeConfiguration;
import org.codehaus.cargo.container.jonas.internal.MBeanServerConnectionFactory;
import org.codehaus.cargo.util.log.Logger;

public class MEJBMBeanServerConnectionFactory
implements MBeanServerConnectionFactory,
CallbackHandler {
    public static final String DEFAULT_JNDI_INITIAL_CTX_FACTORY = "org.objectweb.carol.jndi.spi.MultiOrbInitialContextFactory";
    public static final String DEFAULT_PROVIDER_URI = "rmi://localhost:1099";
    public static final String DEFAULT_JNDI_MEJB_PATH = "ejb/mgmt/MEJB";
    public static final String DEFAULT_JAAS_FILE = "jaas.config";
    protected Logger logger;
    protected String mejbJndiPath;
    protected String initialContextFactory;
    protected String jaasFile;
    protected String jaasEntry;
    protected String username;
    protected String password;
    protected Context jndiContext;

    public MBeanServerConnection getServerConnection(RuntimeConfiguration configuration) throws Exception {
        return this.createConnection(this.readConfiguration(configuration));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Hashtable readConfiguration(RuntimeConfiguration configuration) {
        this.logger = configuration.getLogger();
        String username = configuration.getPropertyValue("cargo.remote.username");
        String password = configuration.getPropertyValue("cargo.remote.password");
        String jndiUrl = configuration.getPropertyValue("cargo.remote.uri");
        this.mejbJndiPath = configuration.getPropertyValue("cargo.jonas.jndi.mejb.path");
        this.initialContextFactory = configuration.getPropertyValue("cargo.jonas.jndi.initial.context.factory");
        if (jndiUrl == null || jndiUrl.trim().length() == 0) {
            jndiUrl = DEFAULT_PROVIDER_URI;
        }
        if (this.mejbJndiPath == null) {
            this.mejbJndiPath = DEFAULT_JNDI_MEJB_PATH;
        }
        if (this.initialContextFactory == null) {
            this.initialContextFactory = DEFAULT_JNDI_INITIAL_CTX_FACTORY;
        }
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("java.naming.factory.initial", this.initialContextFactory);
        props.put("java.naming.provider.url", jndiUrl);
        if (username != null && username.trim().length() > 0 && password != null && password.trim().length() > 0) {
            this.username = username;
            this.password = password;
            props.put("java.naming.security.principal", username);
            props.put("java.naming.security.credentials", password);
            this.logger.debug("Credentials will be used when doing JNDI lookups", this.getClass().getName());
        } else {
            this.logger.debug("No credentials will be used when doing JNDI lookups", this.getClass().getName());
        }
        this.jaasFile = configuration.getPropertyValue("cargo.jonas.mejb.jaas.file");
        this.jaasEntry = configuration.getPropertyValue("cargo.jonas.mejb.jaas.entry");
        if (this.jaasEntry == null) {
            if (this.jaasFile != null) throw new IllegalArgumentException("The cargo.jonas.mejb.jaas.file option has been set without any cargo.jonas.mejb.jaas.entry");
            this.logger.debug("No JAAS options will be used when doing EJB calls", this.getClass().getName());
            return props;
        } else {
            if (this.jaasFile == null) {
                this.jaasFile = DEFAULT_JAAS_FILE;
            }
            this.logger.debug("JAAS options will be used when doing EJB calls, based on the file \"" + this.jaasFile + "\" and entry \"" + this.jaasEntry + "\"", this.getClass().getName());
        }
        return props;
    }

    protected MBeanServerConnection createConnection(Hashtable props) throws Exception {
        if (this.jaasEntry != null) {
            System.setProperty("java.naming.factory.initial", this.initialContextFactory);
            System.setProperty("java.security.auth.login.config", this.jaasFile);
            new LoginContext(this.jaasEntry, this).login();
        }
        this.jndiContext = new InitialContext(props);
        Object objref = this.jndiContext.lookup(this.mejbJndiPath);
        ManagementHome home = (ManagementHome)PortableRemoteObject.narrow((Object)objref, (Class)ManagementHome.class);
        Management mejb = home.create();
        return new MEJBProxy(mejb, this);
    }

    public void destroy() {
        if (this.jndiContext != null) {
            try {
                this.jndiContext.close();
            }
            catch (Exception e) {
                e.getMessage();
            }
            this.jndiContext = null;
        }
    }

    public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            Callback callback = callbacks[i];
            if (callback instanceof NameCallback) {
                if (this.username == null) {
                    throw new NullPointerException("User name not set. Please set it using the \"cargo.remote.username\" option.");
                }
                ((NameCallback)callback).setName(this.username);
                this.logger.debug("Responded to a NameCallback", this.getClass().getName());
                continue;
            }
            if (callback instanceof PasswordCallback) {
                if (this.password == null) {
                    throw new NullPointerException("Password not set. Please set it using the \"cargo.remote.password\" option.");
                }
                ((PasswordCallback)callback).setPassword(this.password.toCharArray());
                this.logger.debug("Responded to a PasswordCallback", this.getClass().getName());
                continue;
            }
            throw new UnsupportedCallbackException(callback, "Unsupported callback type: " + callback.getClass().getName());
        }
    }

    protected static class MEJBProxy
    implements MBeanServerConnection {
        protected Management mejb;
        protected MEJBMBeanServerConnectionFactory parent;

        public MEJBProxy(Management mejb, MEJBMBeanServerConnectionFactory parent) {
            this.mejb = mejb;
            this.parent = parent;
        }

        public void addNotificationListener(ObjectName arg0, NotificationListener arg1, NotificationFilter arg2, Object arg3) throws InstanceNotFoundException, IOException {
            throw new UnsupportedOperationException("MEJB proxy does not support this method call");
        }

        public void addNotificationListener(ObjectName arg0, ObjectName arg1, NotificationFilter arg2, Object arg3) throws InstanceNotFoundException, IOException {
            throw new UnsupportedOperationException("MEJB proxy does not support this method call");
        }

        public ObjectInstance createMBean(String arg0, ObjectName arg1) throws ReflectionException, InstanceAlreadyExistsException, MBeanException, NotCompliantMBeanException, IOException {
            throw new UnsupportedOperationException("MEJB proxy does not support this method call");
        }

        public ObjectInstance createMBean(String arg0, ObjectName arg1, ObjectName arg2) throws ReflectionException, InstanceAlreadyExistsException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
            throw new UnsupportedOperationException("MEJB proxy does not support this method call");
        }

        public ObjectInstance createMBean(String arg0, ObjectName arg1, Object[] arg2, String[] arg3) throws ReflectionException, InstanceAlreadyExistsException, MBeanException, NotCompliantMBeanException, IOException {
            throw new UnsupportedOperationException("MEJB proxy does not support this method call");
        }

        public ObjectInstance createMBean(String arg0, ObjectName arg1, ObjectName arg2, Object[] arg3, String[] arg4) throws ReflectionException, InstanceAlreadyExistsException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
            throw new UnsupportedOperationException("MEJB proxy does not support this method call");
        }

        public Object getAttribute(ObjectName arg0, String arg1) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, IOException {
            return this.mejb.getAttribute(arg0, arg1);
        }

        public AttributeList getAttributes(ObjectName arg0, String[] arg1) throws InstanceNotFoundException, ReflectionException, IOException {
            return this.mejb.getAttributes(arg0, arg1);
        }

        public String getDefaultDomain() throws IOException {
            return this.mejb.getDefaultDomain();
        }

        public String[] getDomains() throws IOException {
            throw new UnsupportedOperationException("MEJB proxy does not support this method call");
        }

        public Integer getMBeanCount() throws IOException {
            return this.mejb.getMBeanCount();
        }

        public MBeanInfo getMBeanInfo(ObjectName arg0) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
            return this.mejb.getMBeanInfo(arg0);
        }

        public ObjectInstance getObjectInstance(ObjectName arg0) throws InstanceNotFoundException, IOException {
            throw new UnsupportedOperationException("MEJB proxy does not support this method call");
        }

        public Object invoke(ObjectName arg0, String arg1, Object[] arg2, String[] arg3) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
            return this.mejb.invoke(arg0, arg1, arg2, arg3);
        }

        public boolean isInstanceOf(ObjectName arg0, String arg1) throws InstanceNotFoundException, IOException {
            throw new UnsupportedOperationException("MEJB proxy does not support this method call");
        }

        public boolean isRegistered(ObjectName arg0) throws IOException {
            return this.mejb.isRegistered(arg0);
        }

        public Set queryMBeans(ObjectName arg0, QueryExp arg1) throws IOException {
            throw new UnsupportedOperationException("MEJB proxy does not support this method call");
        }

        public Set queryNames(ObjectName arg0, QueryExp arg1) throws IOException {
            return this.mejb.queryNames(arg0, arg1);
        }

        public void removeNotificationListener(ObjectName arg0, ObjectName arg1) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
            throw new UnsupportedOperationException("MEJB proxy does not support this method call");
        }

        public void removeNotificationListener(ObjectName arg0, NotificationListener arg1) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
            throw new UnsupportedOperationException("MEJB proxy does not support this method call");
        }

        public void removeNotificationListener(ObjectName arg0, ObjectName arg1, NotificationFilter arg2, Object arg3) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
            throw new UnsupportedOperationException("MEJB proxy does not support this method call");
        }

        public void removeNotificationListener(ObjectName arg0, NotificationListener arg1, NotificationFilter arg2, Object arg3) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
            throw new UnsupportedOperationException("MEJB proxy does not support this method call");
        }

        public void setAttribute(ObjectName arg0, Attribute arg1) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, IOException {
            this.mejb.setAttribute(arg0, arg1);
        }

        public AttributeList setAttributes(ObjectName arg0, AttributeList arg1) throws InstanceNotFoundException, ReflectionException, IOException {
            return this.mejb.setAttributes(arg0, arg1);
        }

        public void unregisterMBean(ObjectName arg0) throws InstanceNotFoundException, MBeanRegistrationException, IOException {
            throw new UnsupportedOperationException("MEJB proxy does not support this method call");
        }
    }
}

