/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.jonas.internal;

import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.configuration.ConfigurationCapability;
import org.codehaus.cargo.container.jonas.internal.JonasStandaloneLocalConfigurationCapability;
import org.codehaus.cargo.container.spi.configuration.AbstractStandaloneLocalConfiguration;
import org.ow2.jonas.tools.configurator.Jonas;
import org.ow2.jonas.tools.configurator.api.JonasConfigurator;

public class AbstractJonasStandaloneLocalConfiguration
extends AbstractStandaloneLocalConfiguration {
    private static final ConfigurationCapability CONTAINER_CAPABILITY = new JonasStandaloneLocalConfigurationCapability();
    protected InstalledLocalContainer installedContainer;

    public AbstractJonasStandaloneLocalConfiguration(String dir) {
        super(dir);
        this.setProperty("cargo.rmi.port", "1099");
        this.setProperty("cargo.protocol", "http");
        this.setProperty("cargo.hostname", "localhost");
        this.setProperty("cargo.servlet.port", "9000");
        this.setProperty("cargo.jvmargs", "-Xms128m -Xmx512m");
    }

    public ConfigurationCapability getCapability() {
        return CONTAINER_CAPABILITY;
    }

    protected void doConfigure(LocalContainer container) throws Exception {
        if (!"http".equals(this.getPropertyValue("cargo.protocol"))) {
            throw new IllegalArgumentException("Currently, the CARGO JOnAS container only supports HTTP");
        }
        this.installedContainer = (InstalledLocalContainer)container;
        this.setupConfigurationDir();
        Jonas jonas = new Jonas(this.installedContainer.getHome());
        JonasConfigurator configurator = jonas.getJonasConfigurator();
        configurator.setJonasBase(this.getHome());
        configurator.setJonasName(this.getPropertyValue("cargo.jonas.server.name"));
        configurator.setJonasName(this.getPropertyValue("cargo.jonas.domain.name"));
        configurator.setServices(this.getPropertyValue("cargo.jonas.services.list"));
        configurator.setHost(this.getPropertyValue("cargo.hostname"));
        configurator.setProtocolsJrmpPort(this.getPropertyValue("cargo.rmi.port"));
        configurator.setHttpPort(this.getPropertyValue("cargo.servlet.port"));
        configurator.execute();
    }
}

