/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.jonas.internal;

import [Ljava.lang.String;;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.RemoteContainer;
import org.codehaus.cargo.container.configuration.RuntimeConfiguration;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.container.jonas.internal.MBeanServerConnectionFactory;
import org.codehaus.cargo.container.spi.deployer.AbstractRemoteDeployer;
import org.codehaus.cargo.util.DefaultFileHandler;

public abstract class AbstractJonasRemoteDeployer
extends AbstractRemoteDeployer {
    protected static final String DEFAULT_JONAS_SERVER_NAME = "jonas";
    protected static final String DEFAULT_JONAS_DOMAIN_NAME = "jonas";
    protected RuntimeConfiguration configuration;

    public AbstractJonasRemoteDeployer(RemoteContainer container) {
        this.configuration = container.getConfiguration();
    }

    public abstract MBeanServerConnectionFactory getMBeanServerConnectionFactory();

    public void deploy(Deployable deployable) {
        WAR war;
        if (deployable.getType() == DeployableType.WAR && (war = (WAR)deployable).isExpandedWar()) {
            this.getLogger().warn("Remote deployer does not supports expanded WAR deployment", ((Object)((Object)this)).getClass().getName());
            return;
        }
        RemoteDeployerConfig config = this.getConfig();
        MBeanServerConnectionFactory factory = null;
        try {
            factory = this.getMBeanServerConnectionFactory();
            MBeanServerConnection mbsc = factory.getServerConnection(this.configuration);
            ObjectName serverMBeanName = this.getServerMBeanName(config.getDomainName(), config.getServerName());
            String filePathOnServer = this.uploadDeployableOnServer(deployable, mbsc, serverMBeanName, config);
            if (config.getClusterName() == null) {
                String operationName = this.getOperationName(ActionType.DEPLOY, deployable.getType(), TargetType.SERVER);
                this.getLogger().debug("Calling deployment operation " + operationName + " on server", ((Object)((Object)this)).getClass().getName());
                mbsc.invoke(serverMBeanName, operationName, new Object[]{filePathOnServer}, new String[]{String.class.getName()});
            } else {
                String operationName = this.getOperationName(ActionType.UPLOAD_DEPLOY, deployable.getType(), TargetType.DOMAIN);
                this.getLogger().debug("Calling deployment operation " + operationName + " on domain master", ((Object)((Object)this)).getClass().getName());
                ObjectName domainMBeanName = this.getDomainMBeanName(config.getDomainName());
                String[] serverNames = (String[])mbsc.invoke(domainMBeanName, "getServerNames", new Object[]{config.getClusterName()}, new String[]{String.class.getName()});
                mbsc.invoke(domainMBeanName, operationName, new Object[]{serverNames, filePathOnServer, Boolean.TRUE}, new String[]{String;.class.getName(), String.class.getName(), Boolean.TYPE.getName()});
            }
        }
        catch (Exception ex) {
            throw new ContainerException("Deployment error", (Throwable)ex);
        }
        finally {
            if (factory != null) {
                factory.destroy();
            }
        }
    }

    protected abstract String getOperationName(ActionType var1, DeployableType var2, TargetType var3);

    public void redeploy(Deployable deployable) {
        try {
            this.undeploy(deployable);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.deploy(deployable);
    }

    public void undeploy(Deployable deployable) {
        RemoteDeployerConfig config = this.getConfig();
        MBeanServerConnectionFactory factory = null;
        try {
            Boolean removed;
            String operationName;
            factory = this.getMBeanServerConnectionFactory();
            MBeanServerConnection mbsc = factory.getServerConnection(this.configuration);
            ObjectName serverMBeanName = this.getServerMBeanName(config.getDomainName(), config.getServerName());
            String remoteFileName = this.getRemoteFileName(deployable, config.getDeployableIdentifier(), true);
            if (config.getClusterName() == null) {
                operationName = this.getOperationName(ActionType.UNDEPLOY, deployable.getType(), TargetType.SERVER);
                this.getLogger().debug("Calling undeployment operation " + operationName + " on server", ((Object)((Object)this)).getClass().getName());
                mbsc.invoke(serverMBeanName, operationName, new Object[]{remoteFileName}, new String[]{String.class.getName()});
                this.getLogger().debug("Calling garbage collector on server", ((Object)((Object)this)).getClass().getName());
                mbsc.invoke(serverMBeanName, "runGC", null, null);
            } else {
                operationName = this.getOperationName(ActionType.UNDEPLOY, deployable.getType(), TargetType.DOMAIN);
                this.getLogger().debug("Calling undeployment operation " + operationName + " on domain master", ((Object)((Object)this)).getClass().getName());
                ObjectName domainMBeanName = this.getDomainMBeanName(config.getDomainName());
                String[] serverNames = (String[])mbsc.getAttribute(domainMBeanName, "serverNames");
                mbsc.invoke(domainMBeanName, operationName, new Object[]{serverNames, remoteFileName}, new String[]{String;.class.getName(), String.class.getName()});
            }
            String skipRemoval = this.configuration.getPropertyValue("cargo.jonas.remote.deployer.skip.module.removal");
            if (!(skipRemoval != null && Boolean.valueOf(skipRemoval).booleanValue() || (removed = (Boolean)mbsc.invoke(serverMBeanName, "removeModuleFile", new Object[]{remoteFileName}, new String[]{String.class.getName()})).booleanValue())) {
                this.getLogger().warn("Unable to remove remote file " + remoteFileName, ((Object)((Object)this)).getClass().getName());
            }
        }
        catch (Exception ex) {
            throw new ContainerException("Undeployment error", (Throwable)ex);
        }
        finally {
            if (factory != null) {
                factory.destroy();
            }
        }
    }

    protected abstract String getRemoteFileName(Deployable var1, String var2, boolean var3);

    protected ObjectName getServerMBeanName(String domainName, String serverName) throws MalformedObjectNameException {
        if (domainName == null || domainName.trim().length() == 0) {
            throw new MalformedObjectNameException("Empty domain name provided");
        }
        if (serverName == null || serverName.trim().length() == 0) {
            throw new MalformedObjectNameException("Empty server name provided");
        }
        return new ObjectName(domainName + ":j2eeType=J2EEServer,name=" + serverName);
    }

    protected ObjectName getDomainMBeanName(String domainName) throws MalformedObjectNameException {
        if (domainName == null || domainName.trim().length() == 0) {
            throw new MalformedObjectNameException("Empty domain name provided");
        }
        return new ObjectName(domainName + ":j2eeType=J2EEDomain,name=" + domainName);
    }

    protected RemoteDeployerConfig getConfig() {
        RemoteDeployerConfig config = new RemoteDeployerConfig();
        config.setDeployableIdentifier(this.configuration.getPropertyValue("cargo.jonas.deployable.identifier"));
        config.setServerName(this.configuration.getPropertyValue("cargo.jonas.server.name"));
        config.setDomainName(this.configuration.getPropertyValue("cargo.jonas.domain.name"));
        config.setClusterName(this.configuration.getPropertyValue("cargo.jonas.cluster.name"));
        if (config.getServerName() == null) {
            config.setServerName("jonas");
        }
        if (config.getDomainName() == null) {
            config.setDomainName("jonas");
        }
        return config;
    }

    private String uploadDeployableOnServer(Deployable deployable, MBeanServerConnection mbsc, ObjectName serverMBeanName, RemoteDeployerConfig config) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        this.getLogger().debug("Uploading file \"" + deployable.getFile() + "\" on server", ((Object)((Object)this)).getClass().getName());
        File file = new File(deployable.getFile());
        DefaultFileHandler fileHandler = new DefaultFileHandler();
        FileInputStream in = new FileInputStream(file);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        fileHandler.copy((InputStream)in, (OutputStream)out);
        in.close();
        String remoteFileName = this.getRemoteFileName(deployable, config.getDeployableIdentifier(), false);
        String filePathOnServer = (String)mbsc.invoke(serverMBeanName, "sendFile", new Object[]{out.toByteArray(), remoteFileName, Boolean.TRUE}, new String[]{[B.class.getName(), String.class.getName(), Boolean.TYPE.getName()});
        if (filePathOnServer == null || filePathOnServer.trim().length() == 0) {
            throw new ContainerException("Server returned a null uploaded file path");
        }
        this.getLogger().debug("File uploaded on server, saved as \"" + filePathOnServer + "\"", ((Object)((Object)this)).getClass().getName());
        return filePathOnServer;
    }

    protected class RemoteDeployerConfig {
        private String deployableIdentifier;
        private String serverName;
        private String domainName;
        private String clusterName;

        protected RemoteDeployerConfig() {
        }

        public String getDeployableIdentifier() {
            return this.deployableIdentifier;
        }

        public void setDeployableIdentifier(String deployableIdentifier) {
            this.deployableIdentifier = deployableIdentifier;
        }

        public String getServerName() {
            return this.serverName;
        }

        public void setServerName(String serverName) {
            this.serverName = serverName;
        }

        public String getDomainName() {
            return this.domainName;
        }

        public void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public String getClusterName() {
            return this.clusterName;
        }

        public void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }
    }

    protected static final class TargetType {
        public static final TargetType SERVER = new TargetType("server");
        public static final TargetType DOMAIN = new TargetType("domain");
        private String type;

        private TargetType(String type) {
            this.type = type;
        }

        public boolean equals(Object object) {
            boolean result = false;
            if (object instanceof TargetType) {
                TargetType type = (TargetType)object;
                if (type.type.equalsIgnoreCase(this.type)) {
                    result = true;
                }
            }
            return result;
        }

        public int hashCode() {
            return this.type.hashCode();
        }

        public String getType() {
            return this.type;
        }

        public String toString() {
            return this.type;
        }
    }

    protected static final class ActionType {
        public static final ActionType DEPLOY = new ActionType("deploy");
        public static final ActionType UPLOAD_DEPLOY = new ActionType("uploadDeploy");
        public static final ActionType UNDEPLOY = new ActionType("undeploy");
        private String type;

        private ActionType(String type) {
            this.type = type;
        }

        public boolean equals(Object object) {
            boolean result = false;
            if (object instanceof ActionType) {
                ActionType type = (ActionType)object;
                if (type.type.equalsIgnoreCase(this.type)) {
                    result = true;
                }
            }
            return result;
        }

        public int hashCode() {
            return this.type.hashCode();
        }

        public String getType() {
            return this.type;
        }

        public String toString() {
            return this.type;
        }
    }
}

