/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.jonas.internal;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.RemoteContainer;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.container.jonas.internal.AbstractJonasRemoteDeployer;
import org.codehaus.cargo.container.jonas.internal.MBeanServerConnectionFactory;

public abstract class AbstractJonas5xRemoteDeployer
extends AbstractJonasRemoteDeployer {
    public AbstractJonas5xRemoteDeployer(RemoteContainer container) {
        super(container);
    }

    protected String getOperationName(AbstractJonasRemoteDeployer.ActionType actionType, DeployableType deployableType, AbstractJonasRemoteDeployer.TargetType targetType) {
        if (targetType == AbstractJonasRemoteDeployer.TargetType.SERVER) {
            String operationName;
            if (actionType == AbstractJonasRemoteDeployer.ActionType.DEPLOY) {
                operationName = "deploy";
            } else if (actionType == AbstractJonasRemoteDeployer.ActionType.UPLOAD_DEPLOY) {
                operationName = "uploadDeploy";
            } else if (actionType == AbstractJonasRemoteDeployer.ActionType.UNDEPLOY) {
                operationName = "undeploy";
            } else {
                throw new IllegalArgumentException("Unsupported Action type: " + actionType);
            }
            return operationName;
        }
        if (targetType == AbstractJonasRemoteDeployer.TargetType.DOMAIN) {
            String operationSuffix;
            String operationPrefix;
            if (actionType == AbstractJonasRemoteDeployer.ActionType.DEPLOY) {
                operationPrefix = "deploy";
            } else if (actionType == AbstractJonasRemoteDeployer.ActionType.UPLOAD_DEPLOY) {
                operationPrefix = "uploadDeploy";
            } else if (actionType == AbstractJonasRemoteDeployer.ActionType.UNDEPLOY) {
                operationPrefix = "unDeploy";
            } else {
                throw new IllegalArgumentException("Unsupported Action type: " + actionType);
            }
            if (deployableType == DeployableType.WAR) {
                operationSuffix = "War";
            } else if (deployableType == DeployableType.EAR) {
                operationSuffix = "Ear";
            } else if (deployableType == DeployableType.EJB) {
                operationSuffix = "Jar";
            } else if (deployableType == DeployableType.RAR) {
                operationSuffix = "Rar";
            } else {
                throw new IllegalArgumentException("Unsupported Deployable type: " + deployableType);
            }
            return operationPrefix + operationSuffix;
        }
        throw new IllegalArgumentException("Unsupported Target type: " + targetType);
    }

    protected String getRemoteFileName(Deployable deployable, String deployableIdentifier, boolean askFromServer) {
        String deployableId = deployableIdentifier;
        if (deployableId != null && deployableId.trim().length() > 0) {
            int identifierExtIndex = deployableId.lastIndexOf(".");
            if (identifierExtIndex != -1) {
                deployableId = deployableId.substring(0, identifierExtIndex);
            }
            if (deployable.getType() == DeployableType.WAR) {
                deployableId = deployableId + ".war";
            } else if (deployable.getType() == DeployableType.EAR) {
                deployableId = deployableId + ".ear";
            } else if (deployable.getType() == DeployableType.EJB) {
                deployableId = deployableId + ".jar";
            } else if (deployable.getType() == DeployableType.RAR) {
                deployableId = deployableId + ".rar";
            } else {
                throw new IllegalArgumentException("Unsupported Deployable type: " + deployable.getType());
            }
            return deployableId;
        }
        File localFile = new File(deployable.getFile());
        String localFileName = localFile.getName();
        if (deployable.getType() == DeployableType.WAR) {
            WAR war = (WAR)deployable;
            localFileName = war.getContext().length() == 0 ? "rootContext.war" : war.getContext() + ".war";
        }
        String result = null;
        if (askFromServer) {
            MBeanServerConnectionFactory factory = null;
            try {
                factory = this.getMBeanServerConnectionFactory();
                MBeanServerConnection mbsc = factory.getServerConnection(this.configuration);
                AbstractJonasRemoteDeployer.RemoteDeployerConfig config = this.getConfig();
                ObjectName serverMBeanName = this.getServerMBeanName(config.getDomainName(), config.getServerName());
                String lookForFile = "/deploy/" + localFileName;
                List remoteFiles = (List)mbsc.getAttribute(serverMBeanName, "deployedFiles");
                Iterator remoteFilesIterator = remoteFiles.iterator();
                while (remoteFilesIterator.hasNext()) {
                    String remoteFile = ((String)remoteFilesIterator.next()).replace('\\', '/');
                    if (!remoteFile.endsWith(lookForFile)) continue;
                    result = remoteFile;
                }
            }
            catch (Exception ex) {
                throw new ContainerException("Undeployment error", (Throwable)ex);
            }
            finally {
                if (factory != null) {
                    factory.destroy();
                }
            }
        } else {
            result = localFileName;
        }
        if (result == null) {
            throw new ContainerException("Cannot find file \"" + localFileName + "\" in JONAS_BASE");
        }
        return result;
    }
}

