/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.jonas;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.Path;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.internal.AntContainerExecutorThread;
import org.codehaus.cargo.container.jonas.internal.AbstractJonasInstalledLocalContainer;
import org.codehaus.cargo.util.AntUtils;

public class Jonas5xInstalledLocalContainer
extends AbstractJonasInstalledLocalContainer {
    public Jonas5xInstalledLocalContainer(LocalConfiguration configuration) {
        super(configuration);
    }

    public void doStart(Java java) {
        this.doAction(java);
        this.doServerAndDomainNameArgs(java);
        java.createArg().setValue("-start");
        AntContainerExecutorThread jonasRunner = new AntContainerExecutorThread(java);
        jonasRunner.start();
        for (int i = 0; i < 40; ++i) {
            Java ping = (Java)new AntUtils().createAntTask("java");
            ping.setFork(true);
            this.doAction(ping);
            this.doServerAndDomainNameArgs(ping);
            ping.createArg().setValue("-ping");
            ping.createArg().setValue("-timeout");
            ping.createArg().setValue("2000");
            ping.createArg().setValue("-manageable.state");
            ping.createArg().setValue("j2ee.state.running");
            ping.reconfigure();
            ping.setTimeout(new Long(10000L));
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                throw new IllegalStateException("Thread.sleep failed");
            }
            int returnCode = ping.executeJava();
            if (returnCode != 0 && returnCode != 1 && returnCode != 2) {
                throw new IllegalStateException("JonasAdmin ping returned " + returnCode + ", the only values allowed are 0, 1 and 2");
            }
            if (returnCode == 0) break;
        }
    }

    public void doStop(Java java) {
        this.doAction(java);
        this.doServerAndDomainNameArgs(java);
        java.createArg().setValue("-halt");
        java.execute();
        try {
            Thread.sleep(2500L);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Thread.sleep failed");
        }
    }

    protected void setupExtraSysProps(Java java, Map configuredSysProps) {
        this.addSysProp(java, configuredSysProps, "org.omg.CORBA.ORBClass", "org.jacorb.orb.ORB");
        this.addSysProp(java, configuredSysProps, "org.omg.CORBA.ORBSingletonClass", "org.jacorb.orb.ORBSingleton");
        this.addSysProp(java, configuredSysProps, "org.omg.PortableInterceptor.ORBInitializerClass.standard_init", "org.jacorb.orb.standardInterceptors.IORInterceptorInitializer");
        this.addSysProp(java, configuredSysProps, "com.sun.CORBA.ORBDynamicStubFactoryFactoryClass", "com.sun.corba.se.impl.presentation.rmi.StubFactoryFactoryStaticImpl");
    }

    public void doAction(Java java) {
        this.setupSysProps(java);
        Path classpath = java.createClasspath();
        classpath.createPathElement().setLocation(new File(this.getHome(), "lib/bootstrap/felix-launcher.jar"));
        classpath.createPathElement().setLocation(new File(this.getHome(), "lib/bootstrap/jonas-commands.jar"));
        classpath.createPathElement().setLocation(new File(this.getHome(), "lib/bootstrap/jonas-version.jar"));
        classpath.createPathElement().setLocation(new File(this.getConfiguration().getHome(), "conf"));
        try {
            this.addToolsJarToClasspath(classpath);
        }
        catch (IOException ex) {
            throw new ContainerException("IOException occured during java command line setup", (Throwable)ex);
        }
        java.setClassname("org.ow2.jonas.commands.admin.ClientAdmin");
        java.setDir(new File(this.getConfiguration().getHome()));
    }

    public String getId() {
        return "jonas5x";
    }

    public String getName() {
        return "JOnAS 5.x";
    }
}

