/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.jonas;

import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.EAR;
import org.codehaus.cargo.container.deployable.EJB;
import org.codehaus.cargo.container.deployable.RAR;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.container.jonas.Jonas4xInstalledLocalContainer;
import org.codehaus.cargo.container.jonas.internal.Jonas4xAdmin;
import org.codehaus.cargo.container.jonas.internal.Jonas4xAdminImpl;
import org.codehaus.cargo.container.spi.deployer.AbstractCopyingInstalledLocalDeployer;
import org.codehaus.cargo.util.CargoException;
import org.codehaus.cargo.util.FileHandler;

public class Jonas4xInstalledLocalDeployer
extends AbstractCopyingInstalledLocalDeployer {
    private Jonas4xAdmin admin;

    public Jonas4xInstalledLocalDeployer(InstalledLocalContainer container) {
        this(container, new Jonas4xAdminImpl((Jonas4xInstalledLocalContainer)container), null);
    }

    public Jonas4xInstalledLocalDeployer(InstalledLocalContainer container, Jonas4xAdmin admin, FileHandler fileHandler) {
        super(container);
        this.admin = admin;
        if (fileHandler != null) {
            super.setFileHandler(fileHandler);
        }
    }

    protected void deployEar(String deployableDir, EAR ear) throws CargoException {
        this.deploy(deployableDir + "/apps", (Deployable)ear, this.getFileHandler().getName(ear.getFile()), new GenericCopyingDeployable());
    }

    protected void deployEjb(String deployableDir, EJB ejb) throws CargoException {
        this.deploy(deployableDir + "/ejbjars", (Deployable)ejb, this.getFileHandler().getName(ejb.getFile()), new GenericCopyingDeployable());
    }

    protected void deployRar(String deployableDir, RAR rar) throws CargoException {
        this.deploy(deployableDir + "/rars", (Deployable)rar, this.getFileHandler().getName(rar.getFile()), new GenericCopyingDeployable());
    }

    protected void deployExpandedWar(String deployableDir, WAR war) throws CargoException {
        if (this.admin.isServerRunning()) {
            this.getLogger().warn("Hot deployment of expanded war impossible", ((Object)((Object)this)).getClass().getName());
            return;
        }
        super.deployExpandedWar(deployableDir + "/webapps/autoload", war);
    }

    protected void deployWar(String deployableDir, WAR war) throws CargoException {
        this.deploy(deployableDir + "/webapps", (Deployable)war, war.getContext() + ".war", new CopyingDeployable(){

            public void copyDeployable(String deployableDir, Deployable deployable) {
                Jonas4xInstalledLocalDeployer.this.getFileHandler().copyFile(deployable.getFile(), Jonas4xInstalledLocalDeployer.this.getFileHandler().append(deployableDir, ((WAR)deployable).getContext() + ".war"));
            }
        });
    }

    public void redeploy(Deployable deployable) throws CargoException {
        this.undeploy(deployable);
        this.deploy(deployable);
    }

    public void undeploy(Deployable deployable) throws CargoException {
        boolean undeployed;
        String fileName = this.getFileHandler().getName(deployable.getFile());
        if (deployable instanceof WAR) {
            fileName = ((WAR)deployable).getContext() + ".war";
        }
        boolean isRunning = false;
        isRunning = this.admin.isServerRunning();
        if (isRunning && !(undeployed = this.admin.unDeploy(fileName))) {
            throw new CargoException("Unable to undeploy file " + fileName + " through JOnAS admin");
        }
    }

    private void deploy(String targetDir, Deployable deployable, String fileName, CopyingDeployable copying) throws CargoException {
        boolean deployed;
        boolean isRunning = false;
        String targetDirectory = targetDir;
        isRunning = this.admin.isServerRunning();
        if (!isRunning) {
            targetDirectory = targetDirectory + "/autoload";
        }
        copying.copyDeployable(targetDirectory, deployable);
        if (isRunning && !(deployed = this.admin.deploy(fileName))) {
            throw new CargoException("Unable to deploy file " + fileName + " through JOnAS admin");
        }
    }

    public String getDeployableDir() {
        return this.getContainer().getConfiguration().getHome();
    }

    private class GenericCopyingDeployable
    implements CopyingDeployable {
        private GenericCopyingDeployable() {
        }

        public void copyDeployable(String deployableDir, Deployable deployable) {
            Jonas4xInstalledLocalDeployer.this.getFileHandler().copyFile(deployable.getFile(), Jonas4xInstalledLocalDeployer.this.getFileHandler().append(deployableDir, Jonas4xInstalledLocalDeployer.this.getFileHandler().getName(deployable.getFile())));
        }
    }

    private static interface CopyingDeployable {
        public void copyDeployable(String var1, Deployable var2);
    }
}

