/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.jetty;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.RemoteContainer;
import org.codehaus.cargo.container.configuration.Configuration;
import org.codehaus.cargo.container.configuration.RuntimeConfiguration;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.container.spi.deployer.AbstractRemoteDeployer;
import org.codehaus.cargo.util.Base64;

public class JettyRemoteDeployer
extends AbstractRemoteDeployer {
    private static final String DEFAULT_DEPLOYER_CONTEXT = "cargo-jetty-deployer";
    private String username;
    private String password;
    private String deployerUrl;

    public JettyRemoteDeployer(RemoteContainer container) {
        RuntimeConfiguration configuration = container.getConfiguration();
        this.username = configuration.getPropertyValue("cargo.remote.username");
        this.password = configuration.getPropertyValue("cargo.remote.password");
        this.deployerUrl = configuration.getPropertyValue("cargo.jetty.deployer.url");
        if (this.deployerUrl == null) {
            this.deployerUrl = this.createDefaultDeployerUrl((Configuration)configuration);
        }
    }

    public void deploy(Deployable deployable) {
        try {
            File webapp = new File(deployable.getFile());
            HttpURLConnection connection = this.createDeployConnection((WAR)deployable);
            this.pipe(new FileInputStream(webapp), connection.getOutputStream());
            String response = this.getResponseMessage(connection);
            if (!response.startsWith("OK -")) {
                throw new ContainerException(response);
            }
        }
        catch (Exception e) {
            throw new ContainerException("Failed to deploy [" + deployable.getFile() + "]", (Throwable)e);
        }
    }

    public void undeploy(Deployable deployable) {
        try {
            HttpURLConnection connection = this.createUndeployConnection((WAR)deployable);
            String response = this.getResponseMessage(connection);
            if (!response.startsWith("OK -")) {
                throw new ContainerException(response);
            }
        }
        catch (Exception e) {
            throw new ContainerException("Failed to undeploy [" + deployable + "]", (Throwable)e);
        }
    }

    public void redeploy(Deployable deployable) {
        this.undeploy(deployable);
        this.deploy(deployable);
    }

    protected HttpURLConnection createDeployConnection(WAR war) throws IOException {
        String deployUrl = this.deployerUrl + "/deploy?path=/" + war.getContext();
        URL url = new URL(deployUrl);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setAllowUserInteraction(false);
        connection.setDoInput(true);
        connection.setDoOutput(true);
        connection.setUseCaches(false);
        connection.setRequestMethod("PUT");
        connection.setRequestProperty("Content-Type", "application/octet-stream");
        try {
            connection.getClass().getMethod("setChunkedStreamingMode", Integer.TYPE).invoke((Object)connection, new Integer(0));
        }
        catch (Exception e) {
            this.getLogger().debug("Not calling setChunkedStreamingMode() method as JVM [" + System.getProperty("java.version") + "] doesn't support it.", ((Object)((Object)this)).getClass().getName());
        }
        if (this.username != null) {
            String authorization = JettyRemoteDeployer.toAuthorization(this.username, this.password);
            connection.setRequestProperty("Authorization", authorization);
        }
        connection.connect();
        return connection;
    }

    protected HttpURLConnection createUndeployConnection(WAR war) throws IOException {
        String undeployURL = this.deployerUrl + "/undeploy?path=/" + war.getContext();
        URL url = new URL(undeployURL);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setAllowUserInteraction(false);
        connection.setDoInput(true);
        connection.setDoOutput(true);
        connection.setUseCaches(false);
        connection.setDoOutput(false);
        connection.setRequestMethod("GET");
        if (this.username != null) {
            String authorization = JettyRemoteDeployer.toAuthorization(this.username, this.password);
            connection.setRequestProperty("Authorization", authorization);
        }
        connection.connect();
        return connection;
    }

    protected String createDefaultDeployerUrl(Configuration configuration) {
        String protocol = configuration.getPropertyValue("cargo.protocol");
        String host = configuration.getPropertyValue("cargo.hostname");
        String port = configuration.getPropertyValue("cargo.servlet.port");
        String deployerUrl = protocol + "://" + host + ":" + port + "/" + DEFAULT_DEPLOYER_CONTEXT;
        return deployerUrl;
    }

    protected String getResponseMessage(HttpURLConnection connection) throws IOException {
        int code = connection.getResponseCode();
        String response = "";
        try {
            response = code >= 400 ? this.streamToString(connection.getInputStream(), "UTF-8") : this.streamToString(connection.getInputStream(), "UTF-8");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return response;
    }

    protected void pipe(InputStream in, OutputStream out) throws IOException {
        int n;
        BufferedOutputStream bufferedOut = new BufferedOutputStream(out);
        byte[] bytes = new byte[4096];
        while ((n = in.read(bytes)) != -1) {
            bufferedOut.write(bytes, 0, n);
        }
        bufferedOut.flush();
        bufferedOut.close();
        in.close();
    }

    protected String streamToString(InputStream in, String charset) throws IOException {
        int n;
        InputStreamReader reader = new InputStreamReader(in, charset);
        StringBuffer buffer = new StringBuffer();
        char[] chars = new char[1024];
        while ((n = reader.read(chars, 0, chars.length)) != -1) {
            buffer.append(chars, 0, n);
        }
        return buffer.toString();
    }

    protected static String toAuthorization(String username, String password) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(username).append(':');
        if (password != null) {
            buffer.append(password);
        }
        return "Basic " + new String(Base64.encodeBase64((byte[])buffer.toString().getBytes()));
    }
}

