/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.jboss;

import java.io.File;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.container.spi.deployer.AbstractCopyingInstalledLocalDeployer;

public class JBossInstalledLocalDeployer
extends AbstractCopyingInstalledLocalDeployer {
    public JBossInstalledLocalDeployer(InstalledLocalContainer container) {
        super(container);
    }

    public String getDeployableDir() {
        String clustered = this.getContainer().getConfiguration().getPropertyValue("cargo.jboss.clustered");
        if (Boolean.valueOf(clustered).booleanValue()) {
            return this.getFileHandler().append(this.getContainer().getConfiguration().getHome(), "farm");
        }
        return this.getFileHandler().append(this.getContainer().getConfiguration().getHome(), "deploy");
    }

    protected void deployExpandedWar(String deployableDir, WAR war) {
        this.getFileHandler().copyDirectory(war.getFile(), this.getFileHandler().append(deployableDir, war.getContext() + ".war"));
    }

    public void redeploy(Deployable deployable) {
        this.undeploy(deployable);
        this.deploy(deployable);
    }

    public void undeploy(Deployable deployable) {
        if (deployable.getType() != DeployableType.WAR) {
            super.undeploy(deployable);
            return;
        }
        WAR war = (WAR)deployable;
        String fileName = this.getFileHandler().append(this.getDeployableDir(), war.getContext() + ".war");
        if (this.fileExists(fileName)) {
            this.getLogger().info("Undeploying [" + fileName + "]...", ((Object)((Object)this)).getClass().getName());
            this.getFileHandler().delete(fileName);
        }
    }

    private boolean fileExists(String fileName) {
        return new File(fileName).exists();
    }
}

