/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.jboss;

import java.io.File;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.configuration.ConfigurationCapability;
import org.codehaus.cargo.container.jboss.JBossInstalledLocalDeployer;
import org.codehaus.cargo.container.jboss.internal.JBossExistingLocalConfigurationCapability;
import org.codehaus.cargo.container.spi.configuration.AbstractExistingLocalConfiguration;

public class JBossExistingLocalConfiguration
extends AbstractExistingLocalConfiguration {
    private static ConfigurationCapability capability = new JBossExistingLocalConfigurationCapability();

    public JBossExistingLocalConfiguration(String dir) {
        super(dir);
        this.setProperty("cargo.rmi.port", "1299");
        this.setProperty("cargo.jboss.configuration", "default");
    }

    protected void doConfigure(LocalContainer container) throws Exception {
        InstalledLocalContainer jbossContainer = (InstalledLocalContainer)container;
        File deployDir = new File(this.getHome(), "deploy");
        if (!deployDir.exists()) {
            throw new ContainerException("Invalid existing configuration: The [" + deployDir.getPath() + "] directory does not exist");
        }
        JBossInstalledLocalDeployer deployer = new JBossInstalledLocalDeployer(jbossContainer);
        deployer.deploy(this.getDeployables());
        this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/cargocpc.war", new File(deployDir, "cargocpc.war"));
    }

    public ConfigurationCapability getCapability() {
        return capability;
    }

    public String toString() {
        return "JBoss Existing Configuration";
    }
}

