/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.geronimo;

import java.io.File;
import org.apache.tools.ant.taskdefs.Java;
import org.codehaus.cargo.container.ContainerCapability;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.State;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.geronimo.internal.GeronimoUtils;
import org.codehaus.cargo.container.internal.AntContainerExecutorThread;
import org.codehaus.cargo.container.internal.J2EEContainerCapability;
import org.codehaus.cargo.container.spi.AbstractInstalledLocalContainer;

public class Geronimo1xInstalledLocalContainer
extends AbstractInstalledLocalContainer {
    public static final String ID = "geronimo1x";
    private ContainerCapability capability = new J2EEContainerCapability();

    public Geronimo1xInstalledLocalContainer(LocalConfiguration configuration) {
        super(configuration);
    }

    public String getId() {
        return ID;
    }

    public String getName() {
        return "Geronimo " + this.getVersion("1.x");
    }

    protected void doStart(Java java) throws Exception {
        java.createJvmarg().setValue("-Xms128m");
        java.createJvmarg().setValue("-Xmx512m");
        java.setJar(new File(this.getHome(), "bin/server.jar"));
        java.addSysproperty(this.getAntUtils().createSysProperty("org.apache.geronimo.base.dir", this.getConfiguration().getHome()));
        java.addSysproperty(this.getAntUtils().createSysProperty("java.io.tmpdir", new File(this.getConfiguration().getHome(), "/var/temp").getPath()));
        AntContainerExecutorThread geronimoStarter = new AntContainerExecutorThread(java);
        geronimoStarter.start();
    }

    protected void doStop(Java java) throws Exception {
        java.setJar(new File(this.getHome(), "bin/shutdown.jar"));
        java.addSysproperty(this.getAntUtils().createSysProperty("org.apache.geronimo.base.dir", this.getConfiguration().getHome()));
        java.addSysproperty(this.getAntUtils().createSysProperty("java.io.tmpdir", new File(this.getConfiguration().getHome(), "/var/temp").getPath()));
        java.createArg().setValue("--user");
        java.createArg().setValue(this.getConfiguration().getPropertyValue("cargo.remote.username"));
        java.createArg().setValue("--password");
        java.createArg().setValue(this.getConfiguration().getPropertyValue("cargo.remote.password"));
        java.createArg().setValue("--port");
        java.createArg().setValue(this.getConfiguration().getPropertyValue("cargo.rmi.port"));
        AntContainerExecutorThread geronimoStopper = new AntContainerExecutorThread(java);
        geronimoStopper.start();
    }

    protected void waitForCompletion(boolean waitForStarting) throws InterruptedException {
        GeronimoUtils geronimoUtils = new GeronimoUtils();
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader geronimoClassLoader = geronimoUtils.createGeronimoURLClassloader(new File(this.getHome()));
        Thread.currentThread().setContextClassLoader(geronimoClassLoader);
        this.getLogger().debug("Checking if Geronimo is started using: hostname [" + this.getConfiguration().getPropertyValue("cargo.hostname") + "], RMI port [" + this.getConfiguration().getPropertyValue("cargo.rmi.port") + "], username [" + this.getConfiguration().getPropertyValue("cargo.remote.username") + "], password [" + this.getConfiguration().getPropertyValue("cargo.remote.password") + "]", ((Object)((Object)this)).getClass().getName());
        try {
            boolean bl;
            boolean exitCondition;
            long startTime = System.currentTimeMillis();
            do {
                if (System.currentTimeMillis() - startTime > this.getTimeout()) {
                    this.setState(State.UNKNOWN);
                    String message = "Container failed to start within the timeout period [" + this.getTimeout() + "]. The Container state is thus unknown.";
                    this.getLogger().info(message, ((Object)((Object)this)).getClass().getName());
                    throw new ContainerException(message);
                }
                Thread.sleep(100L);
                boolean isStarted = geronimoUtils.isGeronimoStarted(this.getConfiguration().getPropertyValue("cargo.hostname"), this.getConfiguration().getPropertyValue("cargo.rmi.port"), this.getConfiguration().getPropertyValue("cargo.remote.username"), this.getConfiguration().getPropertyValue("cargo.remote.password"));
                if (waitForStarting) {
                    if (!isStarted) {
                        bl = true;
                        continue;
                    }
                    bl = false;
                    continue;
                }
                bl = isStarted;
            } while (exitCondition = bl);
        }
        catch (InterruptedException e) {
            this.setState(State.UNKNOWN);
            throw new ContainerException("Failed to monitor container", (Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    public ContainerCapability getCapability() {
        return this.capability;
    }

    protected final String getVersion(String defaultVersion) {
        return defaultVersion;
    }
}

