/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.util;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.cargo.util.CargoException;
import org.codehaus.cargo.util.DefaultFileHandler;
import org.codehaus.cargo.util.ElementNotFoundException;
import org.codehaus.cargo.util.FileHandler;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.XPath;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dom4JUtil {
    private Map<String, String> namespaces;
    private FileHandler fileHandler;

    public Dom4JUtil() {
        this(new DefaultFileHandler());
    }

    public Dom4JUtil(FileHandler fileHandler) {
        this.fileHandler = fileHandler;
        this.setNamespaces(new HashMap<String, String>());
    }

    public List<Element> selectElementsMatchingXPath(String xpath, Element toSearch) {
        XPath xpathSelector = DocumentHelper.createXPath((String)xpath);
        xpathSelector.setNamespaceURIs(this.getNamespaces());
        List results = xpathSelector.selectNodes((Object)toSearch);
        return results;
    }

    public Element selectElementMatchingXPath(String xpath, Element toSearch) {
        List<Element> results = this.selectElementsMatchingXPath(xpath, toSearch);
        if (results.isEmpty()) {
            throw new ElementNotFoundException(xpath, toSearch);
        }
        Element match = results.get(0);
        return match;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeXmlToOutputStream(Document document, OutputStream destination) throws IOException {
        try {
            OutputFormat outformat = OutputFormat.createPrettyPrint();
            XMLWriter writer = new XMLWriter(destination, outformat);
            writer.write(document);
            writer.flush();
            writer.close();
        }
        finally {
            destination.close();
        }
    }

    public Document loadXmlFromFile(String sourceFile) {
        Document xml;
        try {
            SAXReader reader = new SAXReader(false);
            this.setDontAccessExternalResources(reader);
            xml = reader.read(this.getFileHandler().getInputStream(sourceFile));
        }
        catch (DocumentException e) {
            throw new CargoException("Error parsing " + sourceFile, e);
        }
        return xml;
    }

    private void setDontAccessExternalResources(SAXReader reader) {
        try {
            reader.setFeature("http://xml.org/sax/features/external-general-entities", false);
            reader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            reader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (SAXException e) {
            throw new CargoException("Error disabling external xml resources", e);
        }
    }

    public void saveXml(Document document, String filename) {
        OutputStream destination = null;
        try {
            if (!this.getFileHandler().exists(filename)) {
                this.getFileHandler().createFile(filename);
            }
            destination = this.getFileHandler().getOutputStream(filename);
            this.writeXmlToOutputStream(document, destination);
        }
        catch (IOException e) {
            throw new CargoException("Error writing " + filename, e);
        }
    }

    public FileHandler getFileHandler() {
        return this.fileHandler;
    }

    public void setFileHandler(FileHandler fileHandler) {
        this.fileHandler = fileHandler;
    }

    public void setNamespaces(Map<String, String> namespaces) {
        this.namespaces = namespaces;
    }

    public Map<String, String> getNamespaces() {
        return this.namespaces;
    }

    public Element parseIntoElement(String elementToParse) {
        try {
            Document parsed = DocumentHelper.parseText((String)elementToParse);
            return parsed.getRootElement();
        }
        catch (DocumentException e) {
            throw new CargoException("Could not parse element: " + elementToParse);
        }
    }
}

