/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.util.log;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.codehaus.cargo.util.CargoException;
import org.codehaus.cargo.util.internal.log.AbstractLogger;
import org.codehaus.cargo.util.log.LogLevel;

public class FileLogger
extends AbstractLogger {
    private OutputStream output;
    private final DateFormat format = new SimpleDateFormat("HH:mm:ss.SSS");

    public FileLogger(File file, boolean append) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file, append);
            this.output = new BufferedOutputStream(fileOutputStream);
        }
        catch (FileNotFoundException e) {
            throw new CargoException("Failed to create file [" + file + "]", e);
        }
    }

    public FileLogger(String file, boolean append) {
        this(new File(file), append);
    }

    protected void doLog(LogLevel level, String message, String category) {
        String formattedCategory = category.length() > 20 ? category.substring(category.length() - 20) : category;
        String msg = "[" + this.format.format(new Date()) + "]" + "[" + level.getLevel() + "][" + formattedCategory + "] " + message + "\n";
        try {
            this.output.write(msg.getBytes());
            this.output.flush();
        }
        catch (IOException e) {
            throw new CargoException("Failed to write log message [" + msg + "]", e);
        }
    }
}

