/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.util;

import java.util.Iterator;
import java.util.Map;
import org.codehaus.cargo.util.Dom4JUtil;
import org.codehaus.cargo.util.FileHandler;
import org.codehaus.cargo.util.XmlFileBuilder;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.Visitor;
import org.dom4j.VisitorSupport;

public class Dom4JXmlFileBuilder
implements XmlFileBuilder {
    private Dom4JUtil xmlUtil;
    private String path;
    private Document document;

    public Dom4JXmlFileBuilder(FileHandler fileHandler) {
        this.xmlUtil = new Dom4JUtil(fileHandler);
    }

    public void setFile(String path) {
        this.path = path;
    }

    public void insertElementsUnderXPath(String elementsToParse, String xpath) {
        Element parent = this.xmlUtil.selectElementMatchingXPath(xpath, this.document.getRootElement());
        StringBuffer nested = new StringBuffer();
        nested.append("<parent>");
        nested.append(elementsToParse);
        nested.append("</parent>");
        Element nestedElements = this.xmlUtil.parseIntoElement(nested.toString());
        Iterator elements = nestedElements.elements().iterator();
        while (elements.hasNext()) {
            Element element = (Element)elements.next();
            this.setNamespaceOfElementToTheSameAsParent(element, parent);
            nestedElements.remove(element);
            parent.add(element);
        }
    }

    private void setNamespaceOfElementToTheSameAsParent(Element element, Element parent) {
        final Namespace namespaceOfParent = parent.getNamespace();
        element.accept((Visitor)new VisitorSupport(){

            public void visit(Element node) {
                QName nameOfElementWithCorrectNamespace = new QName(node.getName(), namespaceOfParent);
                node.setQName(nameOfElementWithCorrectNamespace);
            }
        });
    }

    public void loadFile() {
        this.document = this.xmlUtil.loadXmlFromFile(this.path);
    }

    public void writeFile() {
        this.xmlUtil.saveXml(this.document, this.path);
    }

    public void setNamespaces(Map namespaces) {
        this.xmlUtil.setNamespaces(namespaces);
    }
}

