/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.module.webapp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.codehaus.cargo.module.Descriptor;
import org.codehaus.cargo.module.DescriptorElement;
import org.codehaus.cargo.module.webapp.EjbRef;
import org.codehaus.cargo.module.webapp.VendorWebAppDescriptor;
import org.codehaus.cargo.module.webapp.WebXml;
import org.codehaus.cargo.module.webapp.WebXmlTag;
import org.codehaus.cargo.module.webapp.elements.ContextParam;
import org.codehaus.cargo.module.webapp.elements.Filter;
import org.codehaus.cargo.module.webapp.elements.FilterMapping;
import org.codehaus.cargo.module.webapp.elements.InitParam;
import org.codehaus.cargo.module.webapp.elements.SecurityConstraint;
import org.codehaus.cargo.module.webapp.elements.Servlet;
import org.codehaus.cargo.module.webapp.elements.WebXmlElement;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.filter.ElementFilter;

public final class WebXmlUtils {
    private WebXmlUtils() {
    }

    public static List<String> getFilterNamesForClass(WebXml webXml, String className) {
        if (className == null) {
            throw new NullPointerException();
        }
        ArrayList<String> filterNames = new ArrayList<String>();
        for (Element element : webXml.getTags("filter")) {
            Filter filterElement = (Filter)element;
            if (!className.equals(filterElement.getFilterClass())) continue;
            filterNames.add(filterElement.getFilterName());
        }
        return filterNames;
    }

    public static List<String> getFilterMappings(WebXml webXml, String theFilterName) {
        if (theFilterName == null) {
            throw new NullPointerException();
        }
        ArrayList<String> filterMappings = new ArrayList<String>();
        for (Element element : webXml.getTags("filter-mapping")) {
            String urlPattern;
            FilterMapping filterMappingElement = (FilterMapping)element;
            if (!theFilterName.equals(filterMappingElement.getFilterName()) || (urlPattern = filterMappingElement.getUrlPattern()) == null) continue;
            filterMappings.add(urlPattern);
        }
        return filterMappings;
    }

    public static List<FilterMapping> getFilterMappingElements(WebXml webXml, String theFilterName) {
        if (theFilterName == null) {
            throw new NullPointerException();
        }
        ArrayList<FilterMapping> filterMappings = new ArrayList<FilterMapping>();
        for (Element element : webXml.getTags("filter-mapping")) {
            FilterMapping filterMappingElement = (FilterMapping)element;
            if (!theFilterName.equals(filterMappingElement.getFilterName())) continue;
            filterMappings.add(filterMappingElement);
        }
        return filterMappings;
    }

    public static boolean hasContextParam(WebXml webXml, String theParamName) {
        return WebXmlUtils.getContextParam(webXml, theParamName) != null;
    }

    public static Element getContextParam(WebXml webXml, String paramName) {
        if (paramName == null) {
            throw new NullPointerException();
        }
        return webXml.getTagByIdentifier("context-param", paramName);
    }

    public static boolean hasFilter(WebXml webXml, String theFilterName) {
        return webXml.getTagByIdentifier("filter", theFilterName) != null;
    }

    public static String getServletRunAsRoleName(WebXml webXml, String theServletName) {
        Element e;
        if (theServletName == null) {
            throw new NullPointerException();
        }
        String roleName = null;
        Servlet servlet = WebXmlUtils.getServlet(webXml, theServletName);
        List nodeList = servlet.getChildren("run-as", servlet.getNamespace());
        if (nodeList != null && nodeList.size() > 0 && (e = (Element)nodeList.get(0)) != null) {
            roleName = e.getChildText("role-name", e.getNamespace());
        }
        return roleName;
    }

    public static void addTagInitParam(WebXmlElement itemElement, String name, String value) {
        WebXmlTag tag = (WebXmlTag)itemElement.getTag().getDescriptorType().getTagByName("init-param");
        InitParam init = new InitParam(tag, name, value);
        itemElement.getChildren().add(init);
    }

    public static List<String> getFilterInitParamNames(WebXml webXml, String name) {
        WebXmlElement element = (WebXmlElement)webXml.getTagByIdentifier("filter", name);
        List items = element.getChildren("init-param", element.getTag().getTagNamespace());
        ArrayList<String> result = new ArrayList<String>(items.size());
        for (Element item : items) {
            InitParam ip = (InitParam)item;
            result.add(ip.getParamName());
        }
        return result;
    }

    public static void addFilterInitParam(WebXml webXml, String name, String paramName, String paramValue) {
        WebXmlElement element = (WebXmlElement)webXml.getTagByIdentifier("filter", name);
        WebXmlUtils.addTagInitParam(element, paramName, paramValue);
    }

    public static boolean hasServlet(WebXml webXml, String servletName) {
        return webXml.getTagByIdentifier("servlet", servletName) != null;
    }

    public static void addServlet(WebXml webXml, String servletName, String servletClass) {
        WebXmlTag tag = (WebXmlTag)webXml.getDescriptorType().getTagByName("servlet");
        Servlet servlet = new Servlet(tag, servletName, servletClass);
        webXml.addTag(servlet);
    }

    public static List<String> getServletNamesForClass(WebXml webXml, String className) {
        List<Element> items = webXml.getTags("servlet");
        ArrayList<String> result = new ArrayList<String>(items.size());
        for (Element item : items) {
            Servlet servlet = (Servlet)item;
            if (!servlet.getServletClass().equals(className)) continue;
            result.add(servlet.getServletName());
        }
        return result;
    }

    public static List<String> getServletNamesForJspFile(WebXml webXml, String theJspFile) {
        if (theJspFile == null) {
            throw new NullPointerException();
        }
        List<Element> servletElements = webXml.getElements("servlet");
        ArrayList<String> servletNames = new ArrayList<String>();
        for (Element servletElement : servletElements) {
            Element thisElement = servletElement.getChild("jsp-file", servletElement.getNamespace());
            if (thisElement == null || !theJspFile.equals(thisElement.getText())) continue;
            servletNames.add(servletElement.getChild("servlet-name", servletElement.getNamespace()).getText());
        }
        return servletNames;
    }

    public static List<String> getServletNames(WebXml webXml) {
        List<Element> items = webXml.getTags("servlet");
        ArrayList<String> result = new ArrayList<String>(items.size());
        for (Element item : items) {
            Servlet servlet = (Servlet)item;
            result.add(servlet.getServletName());
        }
        return result;
    }

    public static List<String> getServletMappings(WebXml webXml, String theServletName) {
        if (theServletName == null) {
            throw new NullPointerException();
        }
        ArrayList<String> servletMappings = new ArrayList<String>();
        List<Element> servletMappingElements = webXml.getElements("servlet-mapping");
        for (Element servletMappingElement : servletMappingElements) {
            String urlPattern;
            if (!theServletName.equals(servletMappingElement.getChild("servlet-name", servletMappingElement.getNamespace()).getText()) || (urlPattern = servletMappingElement.getChild("url-pattern", servletMappingElement.getNamespace()).getText()) == null) continue;
            servletMappings.add(urlPattern);
        }
        return servletMappings;
    }

    public static void addServlet(WebXml webXml, Servlet element) {
        if (element == null) {
            throw new NullPointerException();
        }
        webXml.addTag(element);
    }

    public static void addServletInitParam(WebXml webXml, String theServletName, String name, String value) {
        WebXmlTag tag = (WebXmlTag)webXml.getDescriptorType().getTagByName("init-param");
        Servlet servletElement = WebXmlUtils.getServlet(webXml, theServletName);
        if (servletElement == null) {
            throw new IllegalStateException("Servlet '" + theServletName + "' not defined");
        }
        InitParam ip = new InitParam(tag);
        ip.setParamName(name);
        ip.setParamValue(value);
        Element loadOnStartupElements = servletElement.getChild("load-on-startup", servletElement.getNamespace());
        if (loadOnStartupElements != null) {
            servletElement.addContent(loadOnStartupElements.getParentElement().getChildren().indexOf(loadOnStartupElements), (Content)ip);
        } else {
            servletElement.addContent((Content)ip);
        }
    }

    public static List<String> getServletInitParamNames(WebXml webXml, String theServletName) {
        return WebXmlUtils.getInitParamNames(webXml, WebXmlUtils.getServlet(webXml, theServletName));
    }

    private static List<String> getInitParamNames(WebXml webXml, Element theElement) {
        ArrayList<String> initParamNames = new ArrayList<String>();
        if (theElement != null) {
            List initParamElements = theElement.getChildren("init-param", theElement.getNamespace());
            for (Element initParamElement : initParamElements) {
                String paramName = initParamElement.getChildText("param-name", theElement.getNamespace());
                if (paramName == null) continue;
                initParamNames.add(paramName);
            }
        }
        return initParamNames;
    }

    public static void addSecurityConstraint(WebXml webXml, String theWebResourceName, String theUrlPattern, List<String> theRoles) {
        if (theWebResourceName == null || theUrlPattern == null || theRoles == null) {
            throw new NullPointerException();
        }
        if (WebXmlUtils.hasSecurityConstraint(webXml, theUrlPattern)) {
            throw new IllegalStateException("Security constraint for URL pattern " + theUrlPattern + " already defined");
        }
        WebXmlElement securityConstraintElement = (WebXmlElement)webXml.getDescriptorType().getTagByName("security-constraint").create();
        DescriptorElement webResourceCollectionElement = webXml.getDescriptorType().getTagByName("web-resource-collection").create();
        webResourceCollectionElement.addContent((Content)webXml.getDescriptorType().getTagByName("web-resource-name").create().setText(theWebResourceName));
        webResourceCollectionElement.addContent((Content)webXml.getDescriptorType().getTagByName("url-pattern").create().setText(theUrlPattern));
        securityConstraintElement.addContent((Content)webResourceCollectionElement);
        DescriptorElement authConstraintElement = webXml.getDescriptorType().getTagByName("auth-constraint").create();
        for (String theRole : theRoles) {
            authConstraintElement.addContent((Content)webXml.getDescriptorType().getTagByName("role-name").create().setText(theRole));
        }
        securityConstraintElement.addContent((Content)authConstraintElement);
        webXml.addTag(securityConstraintElement);
    }

    public static void addJspFile(WebXml webXml, String theServletName, String theJspFile) {
        if (theServletName == null) {
            throw new NullPointerException();
        }
        if (WebXmlUtils.hasFilter(webXml, theServletName)) {
            throw new IllegalStateException("Servlet '" + theServletName + "' already defined");
        }
        WebXmlElement servletElement = (WebXmlElement)webXml.getDescriptorType().getTagByName("servlet").create();
        servletElement.addContent((Content)webXml.getDescriptorType().getTagByName("servlet-name").create().setText(theServletName));
        servletElement.addContent((Content)webXml.getDescriptorType().getTagByName("jsp-file").create().setText(theJspFile));
        webXml.addTag(servletElement);
    }

    public static boolean hasSecurityConstraint(WebXml webXml, String theUrlPattern) {
        return WebXmlUtils.getSecurityConstraint(webXml, theUrlPattern) != null;
    }

    public static boolean hasLoginConfig(WebXml webXml) {
        return WebXmlUtils.getLoginConfig(webXml) != null;
    }

    private static Element getLoginConfig(WebXml webXml) {
        return webXml.getTag("login-config");
    }

    public static void setLoginConfig(WebXml webXml, String theAuthMethod, String theRealmName) {
        if (theRealmName == null || theAuthMethod == null) {
            throw new NullPointerException();
        }
        DescriptorElement loginConfigElement = webXml.getDescriptorType().getTagByName("login-config").create();
        loginConfigElement.addContent((Content)webXml.getDescriptorType().getTagByName("auth-method").create().setText(theAuthMethod));
        loginConfigElement.addContent((Content)webXml.getDescriptorType().getTagByName("realm-name").create().setText(theRealmName));
        webXml.getRootElement().removeContent((org.jdom.filter.Filter)new ElementFilter("login-config"));
        webXml.addTag(loginConfigElement);
    }

    public static String getLoginConfigAuthMethod(WebXml webXml) {
        DescriptorElement de = (DescriptorElement)WebXmlUtils.getLoginConfig(webXml);
        return de.getChildText("auth-method", de.getNamespace());
    }

    public static SecurityConstraint getSecurityConstraint(WebXml webXml, String theUrlPattern) {
        if (theUrlPattern == null) {
            throw new NullPointerException();
        }
        List<Element> securityConstraintElements = webXml.getTags("security-constraint");
        SecurityConstraint result = null;
        for (Element securityConstraintElement : securityConstraintElements) {
            List webResourceCollectionElements = securityConstraintElement.getChildren("web-resource-collection", securityConstraintElement.getNamespace());
            if (webResourceCollectionElements.isEmpty()) continue;
            for (Element webResourceCollectionElement : webResourceCollectionElements) {
                String url = webResourceCollectionElement.getChildText("url-pattern", securityConstraintElement.getNamespace());
                if (!theUrlPattern.equals(url)) continue;
                if (result != null) {
                    throw new IllegalStateException("Security constraint for URL pattern '" + theUrlPattern + "' is defined twice");
                }
                result = (SecurityConstraint)securityConstraintElement;
            }
        }
        return result;
    }

    public static boolean hasSecurityRole(WebXml webXml, String theRoleName) {
        return WebXmlUtils.getSecurityRole(webXml, theRoleName) != null;
    }

    public static List<String> getSecurityRoleNames(WebXml webXml) {
        ArrayList<String> securityRoleNames = new ArrayList<String>();
        List<Element> securityRoleElements = webXml.getElements("security-role");
        for (Element securityRoleElement : securityRoleElements) {
            Element securityRoleName = securityRoleElement.getChild("role-name", securityRoleElement.getNamespace());
            if (securityRoleName == null) continue;
            securityRoleNames.add(securityRoleName.getText());
        }
        return securityRoleNames;
    }

    public static Element getSecurityRole(WebXml webXml, String theRoleName) {
        if (theRoleName == null) {
            throw new NullPointerException();
        }
        List<Element> securityRoleElements = webXml.getTags("security-role");
        for (Element element : securityRoleElements) {
            DescriptorElement securityRoleElement = (DescriptorElement)element;
            if (!theRoleName.equals(securityRoleElement.getChildText("role-name", securityRoleElement.getNamespace()))) continue;
            return securityRoleElement;
        }
        return null;
    }

    public static void addEjbRef(WebXml webXml, EjbRef ref) {
        DescriptorElement ejbRefElement = webXml.getDescriptorType().getTagByName("ejb-local-ref").create();
        ejbRefElement.setAttribute("id", ref.getName().replace('/', '_'));
        ejbRefElement.addContent((Content)webXml.getDescriptorType().getTagByName("ejb-ref-name").create().setText(ref.getName()));
        ejbRefElement.addContent((Content)webXml.getDescriptorType().getTagByName("ejb-ref-type").create().setText(ref.getType()));
        if (ref.isLocal()) {
            ejbRefElement.addContent((Content)webXml.getDescriptorType().getTagByName("local-home").create().setText(ref.getEjbHomeInterface()));
            ejbRefElement.addContent((Content)webXml.getDescriptorType().getTagByName("local").create().setText(ref.getEjbInterface()));
        } else {
            ejbRefElement.addContent((Content)webXml.getDescriptorType().getTagByName("home").create().setText(ref.getEjbHomeInterface()));
            ejbRefElement.addContent((Content)webXml.getDescriptorType().getTagByName("remote").create().setText(ref.getEjbInterface()));
        }
        if (ref.getEjbName() != null) {
            ejbRefElement.addContent((Content)webXml.getDescriptorType().getTagByName("ejb-link").create().setText(ref.getEjbName()));
        } else if (ref.getJndiName() != null) {
            for (Descriptor d : webXml.getVendorDescriptors()) {
                VendorWebAppDescriptor descr = (VendorWebAppDescriptor)d;
                descr.addEjbReference(ref);
            }
        } else {
            throw new IllegalStateException("Either ejbName or jndiName must be set.");
        }
        webXml.addTag(ejbRefElement);
    }

    public static void addSecurityRole(WebXml webXml, String theRoleName) {
        if (theRoleName == null) {
            throw new NullPointerException();
        }
        if (WebXmlUtils.hasSecurityRole(webXml, theRoleName)) {
            throw new IllegalStateException("Security role '" + theRoleName + "' already defined");
        }
        DescriptorElement securityRoleElement = webXml.getDescriptorType().getTagByName("security-role").create();
        securityRoleElement.addContent((Content)webXml.getDescriptorType().getTagByName("role-name").create().setText(theRoleName));
        webXml.getRootElement().addContent((Content)securityRoleElement);
    }

    public static Servlet getServlet(WebXml theWebXml, String servletName) {
        return (Servlet)theWebXml.getTagByIdentifier("servlet", servletName);
    }

    public static List<String> getFilterNames(WebXml webXml) {
        List<Element> items = webXml.getTags("filter");
        ArrayList<String> result = new ArrayList<String>(items.size());
        for (Element item : items) {
            Filter filter = (Filter)item;
            result.add(filter.getFilterName());
        }
        return result;
    }

    public static Filter getFilter(WebXml theWebXml, String filterName) {
        return (Filter)theWebXml.getTagByIdentifier("filter", filterName);
    }

    public static void addFilterMapping(WebXml webXml, FilterMapping rhs) {
        String filterName = rhs.getFilterName();
        if (!WebXmlUtils.hasFilter(webXml, filterName)) {
            throw new IllegalStateException("Filter '" + filterName + "' not defined");
        }
        List<FilterMapping> mappings = WebXmlUtils.getFilterMappingElements(webXml, filterName);
        FilterMapping filterMappingElement = null;
        for (FilterMapping mapping : mappings) {
            if (rhs.getUrlPattern() != null) {
                if (!rhs.getUrlPattern().equals(mapping.getUrlPattern())) continue;
                filterMappingElement = mapping;
                break;
            }
            if (rhs.getServletName() == null || !rhs.getServletName().equals(mapping.getServletName())) continue;
            filterMappingElement = mapping;
            break;
        }
        if (filterMappingElement == null) {
            filterMappingElement = (FilterMapping)webXml.getDescriptorType().getTagByName("filter-mapping").create();
            filterMappingElement.addContent((Content)webXml.getDescriptorType().getTagByName("filter-name").create().setText(filterName));
            String urlPattern = rhs.getUrlPattern();
            if (urlPattern != null) {
                filterMappingElement.addContent((Content)webXml.getDescriptorType().getTagByName("url-pattern").create().setText(urlPattern));
            } else {
                String servletName = rhs.getServletName();
                if (servletName == null) {
                    throw new IllegalStateException("Filter '" + filterName + "' has neither a servlet-name nor a url-pattern.");
                }
                filterMappingElement.setServletName(servletName);
            }
        }
        String[] dispatchers = rhs.getDispatchers();
        List<String> filterMappingElementDispatchers = Arrays.asList(filterMappingElement.getDispatchers());
        if (dispatchers != null) {
            for (String dispatcher : dispatchers) {
                if (filterMappingElementDispatchers.contains(dispatcher)) continue;
                filterMappingElement.addDispatcher(dispatcher);
            }
        }
        webXml.addElement(filterMappingElement.getTag(), filterMappingElement, webXml.getRootElement());
    }

    public static String getServletInitParam(WebXml theWebXml, String servletName, String paramName) {
        return WebXmlUtils.getInitParam(theWebXml, WebXmlUtils.getServlet(theWebXml, servletName), paramName);
    }

    private static String getInitParam(WebXml theWebXml, Element theElement, String theParamName) {
        if (theElement != null) {
            List initParamElements = theElement.getChildren("init-param", theElement.getNamespace());
            for (Element initParamElement : initParamElements) {
                String paramName = initParamElement.getChildText("param-name", theElement.getNamespace());
                if (!theParamName.equals(paramName)) continue;
                return initParamElement.getChildText("param-value", theElement.getNamespace());
            }
        }
        return null;
    }

    public static void addServletRunAsRoleName(WebXml webXml, String theServletName, String theRoleName) {
        Servlet servlet = WebXmlUtils.getServlet(webXml, theServletName);
        DescriptorElement runAsElement = webXml.getDescriptorType().getTagByName("run-as").create();
        runAsElement.addContent((Content)webXml.getDescriptorType().getTagByName("role-name").create().setText(theRoleName));
        servlet.addContent((Content)runAsElement);
    }

    public static void addServletMapping(WebXml webXml, String theServletName, String theUrlPattern) {
        if (!WebXmlUtils.hasServlet(webXml, theServletName)) {
            throw new IllegalStateException("Servlet '" + theServletName + "' not defined");
        }
        DescriptorElement servletMappingElement = webXml.getDescriptorType().getTagByName("servlet-mapping").create();
        servletMappingElement.addContent((Content)webXml.getDescriptorType().getTagByName("servlet-name").create().setText(theServletName));
        servletMappingElement.addContent((Content)webXml.getDescriptorType().getTagByName("url-pattern").create().setText(theUrlPattern));
        webXml.addElement(servletMappingElement.getTag(), servletMappingElement, webXml.getRootElement());
    }

    public static String getFilterInitParam(WebXml theWebXml, String filterName, String paramName) {
        Filter filter = (Filter)theWebXml.getTagByIdentifier("filter", filterName);
        if (filter == null) {
            throw new IllegalStateException("Filter '" + filterName + "' not defined");
        }
        InitParam initParam = filter.getInitParam(paramName);
        if (initParam == null) {
            throw new IllegalStateException("Filter '" + filterName + "' Initialization parameter '" + paramName + "' not defined");
        }
        return initParam.getParamValue();
    }

    public static void addFilter(WebXml webXml, Filter filter) {
        webXml.addTag(filter);
    }

    public static void addFilter(WebXml webXml, String filterName, String filterClass) {
        WebXmlTag tag = (WebXmlTag)webXml.getDescriptorType().getTagByName("filter");
        Filter filter = new Filter(tag, filterName, filterClass);
        webXml.addTag(filter);
    }

    public static void addContextParam(WebXml webXml, String name, String value) {
        WebXmlTag tag = (WebXmlTag)webXml.getDescriptorType().getTagByName("context-param");
        ContextParam contextParam = new ContextParam(tag, name, value);
        webXml.addTag(contextParam);
    }
}

