/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.module.webapp.merge;

import java.io.File;
import java.io.IOException;
import org.codehaus.cargo.module.merge.MergeException;
import org.codehaus.cargo.module.merge.MergeProcessor;
import org.codehaus.cargo.module.webapp.WarArchive;
import org.codehaus.cargo.module.webapp.merge.MergedWarArchive;
import org.codehaus.cargo.module.webapp.merge.WebXmlMerger;
import org.codehaus.cargo.util.CargoException;
import org.jdom.JDOMException;

public class WarArchiveMerger
implements MergeProcessor {
    private MergedWarArchive result = new MergedWarArchive();

    public void addMergeProcessor(String path, MergeProcessor merger) {
        if (path == null || merger == null) {
            throw new NullPointerException();
        }
        this.result.addProcessor(path, merger);
    }

    public void addMergeItem(Object mergeItem) throws MergeException {
        if (mergeItem instanceof WarArchive) {
            this.result.add((WarArchive)mergeItem);
        } else if (mergeItem instanceof File) {
            this.result.addJar((File)mergeItem);
        } else {
            throw new MergeException("WarArchiveMerger cannot merge things that are not WarArchives or files");
        }
    }

    public Object performMerge() {
        MergedWarArchive merge = this.result;
        this.result = new MergedWarArchive();
        return merge;
    }

    public void performMerge(File targetFile) throws IOException, JDOMException {
        WarArchive output = (WarArchive)this.performMerge();
        output.store(targetFile);
    }

    public void setMergeJarFiles(boolean doMergeJarFiles) {
        this.result.mergeJarFiles(doMergeJarFiles);
    }

    public WebXmlMerger getWebXmlMerger() {
        try {
            return this.result.getWebXmlMerger();
        }
        catch (Exception ex) {
            throw new CargoException("Exception getting web xml merger", (Throwable)ex);
        }
    }
}

