/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.module.webapp.merge;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.cargo.module.AbstractDescriptorIo;
import org.codehaus.cargo.module.merge.MergeException;
import org.codehaus.cargo.module.merge.MergeProcessor;
import org.codehaus.cargo.module.webapp.WarArchive;
import org.codehaus.cargo.module.webapp.WebXml;
import org.codehaus.cargo.module.webapp.merge.ArchiveResourceMerger;
import org.codehaus.cargo.module.webapp.merge.MergeWarFileDetails;
import org.codehaus.cargo.module.webapp.merge.WebXmlMerger;
import org.codehaus.cargo.util.DefaultFileHandler;
import org.codehaus.cargo.util.JarUtils;
import org.jdom.JDOMException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergedWarArchive
implements WarArchive {
    private List<MergeWarFileDetails> warFiles = new ArrayList<MergeWarFileDetails>();
    private List<File> jarFiles = new ArrayList<File>();
    private boolean mergeJarFiles = true;
    private WebXml mergedWebXml;
    private List<ArchiveResourceMerger> mergeProcessors = new ArrayList<ArchiveResourceMerger>();
    private WebXmlMerger webXmlMerger;

    MergedWarArchive() {
    }

    protected WarArchive firstWarFile() {
        return this.warFiles.get(0).getWarFile();
    }

    public void addProcessor(String path, MergeProcessor merger) {
        this.mergeProcessors.add(new ArchiveResourceMerger(path, merger));
    }

    void add(WarArchive warFile) {
        this.warFiles.add(new MergeWarFileDetails(warFile));
    }

    void addJar(File jarFile) {
        this.jarFiles.add(jarFile);
    }

    public WebXmlMerger getWebXmlMerger() throws IOException, JDOMException {
        if (this.webXmlMerger == null) {
            this.webXmlMerger = new WebXmlMerger(this.firstWarFile().getWebXml());
        }
        return this.webXmlMerger;
    }

    @Override
    public WebXml getWebXml() throws IOException, JDOMException {
        if (this.mergedWebXml == null) {
            WebXmlMerger wxm = this.getWebXmlMerger();
            for (int cnt = 1; cnt < this.warFiles.size(); ++cnt) {
                MergeWarFileDetails details = this.warFiles.get(cnt);
                WarArchive wa = details.getWarFile();
                wxm.merge(wa.getWebXml());
            }
            this.mergedWebXml = wxm.getResult();
        }
        return this.mergedWebXml;
    }

    protected void executeMergeProcessors(File assembleDir) throws MergeException, IOException {
        for (ArchiveResourceMerger processor : this.mergeProcessors) {
            for (MergeWarFileDetails details : this.warFiles) {
                WarArchive wa = details.getWarFile();
                processor.addMergeItem(wa);
            }
            processor.execute(assembleDir);
        }
    }

    @Override
    public void store(File warFile) throws MergeException, IOException, JDOMException {
        DefaultFileHandler fileHandler = new DefaultFileHandler();
        String assembleDir = fileHandler.createUniqueTmpDirectory();
        this.merge(assembleDir);
        new JarUtils().createJarFromDirectory(assembleDir, warFile);
        fileHandler.delete(assembleDir);
    }

    public void merge(String assembleDir) throws MergeException, IOException, JDOMException {
        DefaultFileHandler fileHandler = new DefaultFileHandler();
        WebXml mergedWebXml = this.getWebXml();
        this.expandToPath(assembleDir);
        if (!this.mergeJarFiles) {
            File f = new File(assembleDir);
            File webInfLib = new File(f, "WEB-INF/lib");
            File[] files = webInfLib.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory() || !files[i].getName().toLowerCase().endsWith(".jar")) continue;
                fileHandler.delete(files[i].getAbsolutePath());
            }
        }
        this.copyJars(assembleDir);
        AbstractDescriptorIo.writeAll(mergedWebXml, fileHandler.append(new File(assembleDir).getAbsolutePath(), File.separator + "WEB-INF"));
        this.executeMergeProcessors(new File(assembleDir));
    }

    private void copyJars(String assembleDir) {
        DefaultFileHandler fileHandler = new DefaultFileHandler();
        File f = new File(assembleDir);
        File webInfLib = new File(f, "WEB-INF/lib");
        fileHandler.mkdirs(webInfLib.getAbsolutePath());
        for (File sourceFile : this.jarFiles) {
            fileHandler.copyFile(sourceFile.getAbsolutePath(), new File(webInfLib, sourceFile.getName()).getAbsolutePath());
        }
    }

    @Override
    public boolean containsClass(String theClassName) throws IOException {
        for (MergeWarFileDetails details : this.warFiles) {
            WarArchive wa = details.getWarFile();
            if (!wa.containsClass(theClassName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String findResource(String theName) throws IOException {
        for (MergeWarFileDetails details : this.warFiles) {
            WarArchive wa = details.getWarFile();
            String res = wa.findResource(theName);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    @Override
    public InputStream getResource(String thePath) throws IOException {
        for (MergeWarFileDetails details : this.warFiles) {
            WarArchive wa = details.getWarFile();
            InputStream is = wa.getResource(thePath);
            if (is == null) continue;
            return is;
        }
        return null;
    }

    @Override
    public List<String> getResources(String thePath) throws IOException {
        ArrayList<String> results = new ArrayList<String>();
        for (MergeWarFileDetails details : this.warFiles) {
            WarArchive wa = details.getWarFile();
            results.addAll(wa.getResources(thePath));
        }
        return results;
    }

    @Override
    public void expandToPath(String path) throws IOException {
        this.expandToPath(path, null);
    }

    @Override
    public void expandToPath(String path, FileFilter filter) throws IOException {
        for (MergeWarFileDetails details : this.warFiles) {
            WarArchive wa = details.getWarFile();
            wa.expandToPath(path, filter);
        }
    }

    public void mergeJarFiles(boolean mergeJarFiles) {
        this.mergeJarFiles = mergeJarFiles;
    }
}

