/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.generic.deployer;

import java.lang.reflect.Constructor;
import org.codehaus.cargo.container.Container;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.ContainerType;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.RemoteContainer;
import org.codehaus.cargo.container.deployer.Deployer;
import org.codehaus.cargo.container.deployer.DeployerType;
import org.codehaus.cargo.generic.AbstractFactoryRegistry;
import org.codehaus.cargo.generic.deployer.DeployerFactory;
import org.codehaus.cargo.generic.internal.util.RegistrationKey;
import org.codehaus.cargo.generic.internal.util.SimpleContainerIdentity;
import org.codehaus.cargo.generic.spi.AbstractGenericHintFactory;
import org.codehaus.cargo.generic.spi.AbstractIntrospectionGenericHintFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDeployerFactory
extends AbstractIntrospectionGenericHintFactory<Deployer>
implements DeployerFactory {
    public DefaultDeployerFactory() {
        this(null);
    }

    public DefaultDeployerFactory(ClassLoader classLoader) {
        AbstractFactoryRegistry.register(classLoader, this);
    }

    @Override
    public void registerDeployer(String containerId, DeployerType deployerType, Class<? extends Deployer> deployerClass) {
        this.registerImplementation(new RegistrationKey(new SimpleContainerIdentity(containerId), deployerType.getType()), deployerClass);
    }

    public void registerDeployer(String containerId, DeployerType deployerType, String deployerClassName) {
        this.registerImplementation(new RegistrationKey(new SimpleContainerIdentity(containerId), deployerType.getType()), deployerClassName);
    }

    @Override
    public boolean isDeployerRegistered(String containerId, DeployerType deployerType) {
        return this.hasMapping(new RegistrationKey(new SimpleContainerIdentity(containerId), deployerType.getType()));
    }

    @Override
    public Class<? extends Deployer> getDeployerClass(String containerId, DeployerType deployerType) {
        return this.getMapping(new RegistrationKey(new SimpleContainerIdentity(containerId), deployerType.getType()));
    }

    @Override
    public Deployer createDeployer(Container container, DeployerType deployerType) {
        DeployerFactoryParameters parameters = new DeployerFactoryParameters();
        parameters.container = container;
        return (Deployer)this.createImplementation(new RegistrationKey(new SimpleContainerIdentity(container.getId()), deployerType.getType()), parameters, "deployer");
    }

    @Override
    public Deployer createDeployer(Container container) {
        DeployerType type = DeployerType.toType((ContainerType)container.getType());
        if (!this.isDeployerRegistered(container.getId(), type)) {
            throw new ContainerException("There's no registered deployer matching your container's type of [" + container.getType().getType() + "]");
        }
        this.getLogger().debug("Creating a default [" + type + "] deployer", this.getClass().getName());
        Deployer deployer = this.createDeployer(container, type);
        return deployer;
    }

    @Override
    protected Constructor<? extends Deployer> getConstructor(Class<? extends Deployer> deployerClass, String hint, AbstractGenericHintFactory.GenericParameters parameters) throws NoSuchMethodException {
        Constructor<?> result = null;
        DeployerType type = DeployerType.toType((String)hint);
        if (type == DeployerType.INSTALLED || type == DeployerType.EMBEDDED) {
            Constructor<?>[] constructors;
            for (Constructor<?> constructor : constructors = deployerClass.getConstructors()) {
                Class<?> parameter;
                Class<?>[] parameterTypes = constructor.getParameterTypes();
                if (parameterTypes == null || parameterTypes.length != 1 || !LocalContainer.class.isAssignableFrom(parameter = parameterTypes[0])) continue;
                result = constructor;
                break;
            }
        } else if (type == DeployerType.REMOTE) {
            Constructor<?>[] constructors;
            for (Constructor<?> constructor : constructors = deployerClass.getConstructors()) {
                Class<?> parameter;
                Class<?>[] parameterTypes = constructor.getParameterTypes();
                if (parameterTypes == null || parameterTypes.length != 1 || !RemoteContainer.class.isAssignableFrom(parameter = parameterTypes[0])) continue;
                result = constructor;
                break;
            }
        } else {
            throw new ContainerException("Unknown deployer type [" + type.getType() + "]");
        }
        if (result == null) {
            throw new NoSuchMethodException("No constructor found on class " + deployerClass + " for deployer type [" + type.getType() + "]");
        }
        return result;
    }

    @Override
    protected Deployer createInstance(Constructor<? extends Deployer> constructor, String hint, AbstractGenericHintFactory.GenericParameters parameters) throws Exception {
        Container container = ((DeployerFactoryParameters)parameters).container;
        return constructor.newInstance(container);
    }

    private static class DeployerFactoryParameters
    implements AbstractGenericHintFactory.GenericParameters {
        public Container container;

        private DeployerFactoryParameters() {
        }
    }
}

