/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.generic.deployer;

import java.lang.reflect.Constructor;
import org.codehaus.cargo.container.Container;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.ContainerType;
import org.codehaus.cargo.container.EmbeddedLocalContainer;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.RemoteContainer;
import org.codehaus.cargo.container.deployer.Deployer;
import org.codehaus.cargo.container.deployer.DeployerType;
import org.codehaus.cargo.generic.AbstractFactoryRegistry;
import org.codehaus.cargo.generic.deployer.DeployerFactory;
import org.codehaus.cargo.generic.internal.util.RegistrationKey;
import org.codehaus.cargo.generic.internal.util.SimpleContainerIdentity;
import org.codehaus.cargo.generic.spi.AbstractGenericHintFactory;
import org.codehaus.cargo.generic.spi.AbstractIntrospectionGenericHintFactory;

public class DefaultDeployerFactory
extends AbstractIntrospectionGenericHintFactory
implements DeployerFactory {
    public DefaultDeployerFactory() {
        this(null);
    }

    public DefaultDeployerFactory(ClassLoader classLoader) {
        this.registerGeronimo();
        this.registerJBoss();
        this.registerJetty();
        this.registerJO();
        this.registerJOnAS();
        this.registerJRun();
        this.registerOrion();
        this.registerResin();
        this.registerTomcat();
        this.registerWeblogic();
        AbstractFactoryRegistry.register(classLoader, this);
    }

    public void registerGeronimo() {
        this.registerDeployer("geronimo1x", DeployerType.INSTALLED, "org.codehaus.cargo.container.geronimo.GeronimoInstalledLocalDeployer");
    }

    public void registerJBoss() {
        this.registerDeployer("jboss3x", DeployerType.INSTALLED, "org.codehaus.cargo.container.jboss.JBossInstalledLocalDeployer");
        this.registerDeployer("jboss4x", DeployerType.INSTALLED, "org.codehaus.cargo.container.jboss.JBossInstalledLocalDeployer");
        this.registerDeployer("jboss4x", DeployerType.REMOTE, "org.codehaus.cargo.container.jboss.JBossRemoteDeployer");
        this.registerDeployer("jboss42x", DeployerType.INSTALLED, "org.codehaus.cargo.container.jboss.JBossInstalledLocalDeployer");
        this.registerDeployer("jboss42x", DeployerType.REMOTE, "org.codehaus.cargo.container.jboss.JBossRemoteDeployer");
        this.registerDeployer("jboss5x", DeployerType.INSTALLED, "org.codehaus.cargo.container.jboss.JBossInstalledLocalDeployer");
        this.registerDeployer("jboss5x", DeployerType.REMOTE, "org.codehaus.cargo.container.jboss.JBossRemoteDeployer");
    }

    public void registerJetty() {
        this.registerDeployer("jetty4x", DeployerType.EMBEDDED, "org.codehaus.cargo.container.jetty.Jetty4xEmbeddedLocalDeployer");
        this.registerDeployer("jetty5x", DeployerType.EMBEDDED, "org.codehaus.cargo.container.jetty.Jetty5xEmbeddedLocalDeployer");
        this.registerDeployer("jetty6x", DeployerType.EMBEDDED, "org.codehaus.cargo.container.jetty.Jetty6xEmbeddedLocalDeployer");
        this.registerDeployer("jetty6x", DeployerType.INSTALLED, "org.codehaus.cargo.container.jetty.Jetty6xInstalledLocalDeployer");
        this.registerDeployer("jetty6x", DeployerType.REMOTE, "org.codehaus.cargo.container.jetty.JettyRemoteDeployer");
        this.registerDeployer("jetty7x", DeployerType.EMBEDDED, "org.codehaus.cargo.container.jetty.Jetty6xEmbeddedLocalDeployer");
        this.registerDeployer("jetty7x", DeployerType.INSTALLED, "org.codehaus.cargo.container.jetty.Jetty6xInstalledLocalDeployer");
        this.registerDeployer("jetty7x", DeployerType.REMOTE, "org.codehaus.cargo.container.jetty.JettyRemoteDeployer");
    }

    public void registerJO() {
        this.registerDeployer("jo1x", DeployerType.INSTALLED, "org.codehaus.cargo.container.jo.Jo1xInstalledLocalDeployer");
    }

    public void registerJOnAS() {
        this.registerDeployer("jonas4x", DeployerType.REMOTE, "org.codehaus.cargo.container.jonas.Jonas4xJsr160RemoteDeployer");
        this.registerDeployer("jonas4x", DeployerType.INSTALLED, "org.codehaus.cargo.container.jonas.Jonas4xInstalledLocalDeployer");
        this.registerDeployer("jonas5x", DeployerType.REMOTE, "org.codehaus.cargo.container.jonas.Jonas5xJsr160RemoteDeployer");
        this.registerDeployer("jonas5x", DeployerType.INSTALLED, "org.codehaus.cargo.container.jonas.Jonas5xInstalledLocalDeployer");
    }

    public void registerJRun() {
        this.registerDeployer("jrun4x", DeployerType.INSTALLED, "org.codehaus.cargo.container.jrun.JRun4xInstalledLocalDeployer");
    }

    public void registerOrion() {
    }

    public void registerResin() {
        this.registerDeployer("resin2x", DeployerType.INSTALLED, "org.codehaus.cargo.container.resin.ResinInstalledLocalDeployer");
        this.registerDeployer("resin3x", DeployerType.INSTALLED, "org.codehaus.cargo.container.resin.ResinInstalledLocalDeployer");
    }

    public void registerTomcat() {
        this.registerDeployer("tomcat4x", DeployerType.INSTALLED, "org.codehaus.cargo.container.tomcat.TomcatCopyingInstalledLocalDeployer");
        this.registerDeployer("tomcat4x", DeployerType.REMOTE, "org.codehaus.cargo.container.tomcat.Tomcat4xRemoteDeployer");
        this.registerDeployer("tomcat5x", DeployerType.INSTALLED, "org.codehaus.cargo.container.tomcat.TomcatCopyingInstalledLocalDeployer");
        this.registerDeployer("tomcat5x", DeployerType.REMOTE, "org.codehaus.cargo.container.tomcat.Tomcat5xRemoteDeployer");
        this.registerDeployer("tomcat5x", DeployerType.EMBEDDED, "org.codehaus.cargo.container.tomcat.Tomcat5xEmbeddedLocalDeployer");
        this.registerDeployer("tomcat6x", DeployerType.INSTALLED, "org.codehaus.cargo.container.tomcat.TomcatCopyingInstalledLocalDeployer");
        this.registerDeployer("tomcat6x", DeployerType.REMOTE, "org.codehaus.cargo.container.tomcat.Tomcat6xRemoteDeployer");
    }

    public void registerWeblogic() {
        this.registerDeployer("weblogic8x", DeployerType.INSTALLED, "org.codehaus.cargo.container.weblogic.WebLogic8xSwitchableLocalDeployer");
        this.registerDeployer("weblogic9x", DeployerType.INSTALLED, "org.codehaus.cargo.container.weblogic.WebLogicCopyingInstalledLocalDeployer");
        this.registerDeployer("weblogic10x", DeployerType.INSTALLED, "org.codehaus.cargo.container.weblogic.WebLogicCopyingInstalledLocalDeployer");
        this.registerDeployer("weblogic103x", DeployerType.INSTALLED, "org.codehaus.cargo.container.weblogic.WebLogicCopyingInstalledLocalDeployer");
    }

    public void registerDeployer(String containerId, DeployerType deployerType, Class deployerClass) {
        this.registerImplementation(new RegistrationKey(new SimpleContainerIdentity(containerId), deployerType.getType()), deployerClass);
    }

    public void registerDeployer(String containerId, DeployerType deployerType, String deployerClassName) {
        this.registerImplementation(new RegistrationKey(new SimpleContainerIdentity(containerId), deployerType.getType()), deployerClassName);
    }

    public boolean isDeployerRegistered(String containerId, DeployerType deployerType) {
        return this.hasMapping(new RegistrationKey(new SimpleContainerIdentity(containerId), deployerType.getType()));
    }

    public Class getDeployerClass(String containerId, DeployerType deployerType) {
        return this.getMapping(new RegistrationKey(new SimpleContainerIdentity(containerId), deployerType.getType()));
    }

    public Deployer createDeployer(Container container, DeployerType deployerType) {
        DeployerFactoryParameters parameters = new DeployerFactoryParameters();
        parameters.container = container;
        return (Deployer)this.createImplementation(new RegistrationKey(new SimpleContainerIdentity(container.getId()), deployerType.getType()), parameters, "deployer");
    }

    public Deployer createDeployer(Container container) {
        DeployerType type = DeployerType.toType((ContainerType)container.getType());
        if (!this.isDeployerRegistered(container.getId(), type)) {
            throw new ContainerException("There's no registered deployer matching your container's type of [" + container.getType().getType() + "]");
        }
        this.getLogger().debug("Creating a default [" + type + "] deployer", this.getClass().getName());
        Deployer deployer = this.createDeployer(container, type);
        return deployer;
    }

    protected Constructor getConstructor(Class deployerClass, String hint, AbstractGenericHintFactory.GenericParameters parameters) throws NoSuchMethodException {
        Constructor constructor;
        DeployerType type = DeployerType.toType((String)hint);
        if (type == DeployerType.INSTALLED) {
            constructor = deployerClass.getConstructor(InstalledLocalContainer.class);
        } else if (type == DeployerType.EMBEDDED) {
            constructor = deployerClass.getConstructor(EmbeddedLocalContainer.class);
        } else if (type == DeployerType.REMOTE) {
            constructor = deployerClass.getConstructor(RemoteContainer.class);
        } else {
            throw new ContainerException("Unknown deployer type [" + type.getType() + "]");
        }
        return constructor;
    }

    protected Object createInstance(Constructor constructor, String hint, AbstractGenericHintFactory.GenericParameters parameters) throws Exception {
        Container container = ((DeployerFactoryParameters)parameters).container;
        return constructor.newInstance(container);
    }

    private static class DeployerFactoryParameters
    implements AbstractGenericHintFactory.GenericParameters {
        public Container container;

        private DeployerFactoryParameters() {
        }
    }
}

