/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.generic;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.codehaus.cargo.container.Container;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.ContainerType;
import org.codehaus.cargo.container.configuration.Configuration;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.configuration.RuntimeConfiguration;
import org.codehaus.cargo.generic.AbstractFactoryRegistry;
import org.codehaus.cargo.generic.ContainerFactory;
import org.codehaus.cargo.generic.internal.util.RegistrationKey;
import org.codehaus.cargo.generic.internal.util.SimpleContainerIdentity;
import org.codehaus.cargo.generic.spi.AbstractGenericHintFactory;
import org.codehaus.cargo.generic.spi.AbstractIntrospectionGenericHintFactory;

public class DefaultContainerFactory
extends AbstractIntrospectionGenericHintFactory
implements ContainerFactory {
    public DefaultContainerFactory() {
        this(null);
    }

    public DefaultContainerFactory(ClassLoader classLoader) {
        this.registerGeronimo();
        this.registerJBoss();
        this.registerJetty();
        this.registerJO();
        this.registerJOnAS();
        this.registerJRun();
        this.registerOrion();
        this.registerResin();
        this.registerTomcat();
        this.registerWeblogic();
        AbstractFactoryRegistry.register(classLoader, this);
    }

    public void registerGeronimo() {
        this.registerContainer("geronimo1x", ContainerType.INSTALLED, "org.codehaus.cargo.container.geronimo.Geronimo1xInstalledLocalContainer");
    }

    public void registerJBoss() {
        this.registerContainer("jboss3x", ContainerType.INSTALLED, "org.codehaus.cargo.container.jboss.JBoss3xInstalledLocalContainer");
        this.registerContainer("jboss4x", ContainerType.INSTALLED, "org.codehaus.cargo.container.jboss.JBoss4xInstalledLocalContainer");
        this.registerContainer("jboss4x", ContainerType.REMOTE, "org.codehaus.cargo.container.jboss.JBoss4xRemoteContainer");
        this.registerContainer("jboss42x", ContainerType.INSTALLED, "org.codehaus.cargo.container.jboss.JBoss42xInstalledLocalContainer");
        this.registerContainer("jboss42x", ContainerType.REMOTE, "org.codehaus.cargo.container.jboss.JBoss42xRemoteContainer");
        this.registerContainer("jboss5x", ContainerType.INSTALLED, "org.codehaus.cargo.container.jboss.JBoss5xInstalledLocalContainer");
        this.registerContainer("jboss5x", ContainerType.REMOTE, "org.codehaus.cargo.container.jboss.JBoss5xRemoteContainer");
    }

    public void registerJetty() {
        this.registerContainer("jetty4x", ContainerType.EMBEDDED, "org.codehaus.cargo.container.jetty.Jetty4xEmbeddedLocalContainer");
        this.registerContainer("jetty5x", ContainerType.EMBEDDED, "org.codehaus.cargo.container.jetty.Jetty5xEmbeddedLocalContainer");
        this.registerContainer("jetty6x", ContainerType.EMBEDDED, "org.codehaus.cargo.container.jetty.Jetty6xEmbeddedLocalContainer");
        this.registerContainer("jetty6x", ContainerType.INSTALLED, "org.codehaus.cargo.container.jetty.Jetty6xInstalledLocalContainer");
        this.registerContainer("jetty6x", ContainerType.REMOTE, "org.codehaus.cargo.container.jetty.Jetty6xRemoteContainer");
        this.registerContainer("jetty7x", ContainerType.EMBEDDED, "org.codehaus.cargo.container.jetty.Jetty7xEmbeddedLocalContainer");
        this.registerContainer("jetty7x", ContainerType.INSTALLED, "org.codehaus.cargo.container.jetty.Jetty7xInstalledLocalContainer");
        this.registerContainer("jetty7x", ContainerType.REMOTE, "org.codehaus.cargo.container.jetty.Jetty7xRemoteContainer");
    }

    public void registerJO() {
        this.registerContainer("jo1x", ContainerType.INSTALLED, "org.codehaus.cargo.container.jo.Jo1xInstalledLocalContainer");
    }

    public void registerJOnAS() {
        this.registerContainer("jonas4x", ContainerType.REMOTE, "org.codehaus.cargo.container.jonas.Jonas4xRemoteContainer");
        this.registerContainer("jonas4x", ContainerType.INSTALLED, "org.codehaus.cargo.container.jonas.Jonas4xInstalledLocalContainer");
        this.registerContainer("jonas5x", ContainerType.REMOTE, "org.codehaus.cargo.container.jonas.Jonas5xRemoteContainer");
        this.registerContainer("jonas5x", ContainerType.INSTALLED, "org.codehaus.cargo.container.jonas.Jonas5xInstalledLocalContainer");
    }

    public void registerJRun() {
        this.registerContainer("jrun4x", ContainerType.INSTALLED, "org.codehaus.cargo.container.jrun.JRun4xInstalledLocalContainer");
    }

    public void registerOrion() {
        this.registerContainer("orion1x", ContainerType.INSTALLED, "org.codehaus.cargo.container.orion.Orion1xInstalledLocalContainer");
        this.registerContainer("orion2x", ContainerType.INSTALLED, "org.codehaus.cargo.container.orion.Orion2xInstalledLocalContainer");
        this.registerContainer("oc4j9x", ContainerType.INSTALLED, "org.codehaus.cargo.container.orion.Oc4j9xInstalledLocalContainer");
        this.registerContainer("oc4j10x", ContainerType.INSTALLED, "org.codehaus.cargo.container.orion.Oc4j10xInstalledLocalContainer");
    }

    public void registerResin() {
        this.registerContainer("resin2x", ContainerType.INSTALLED, "org.codehaus.cargo.container.resin.Resin2xInstalledLocalContainer");
        this.registerContainer("resin3x", ContainerType.INSTALLED, "org.codehaus.cargo.container.resin.Resin3xInstalledLocalContainer");
    }

    public void registerTomcat() {
        this.registerContainer("tomcat4x", ContainerType.INSTALLED, "org.codehaus.cargo.container.tomcat.Tomcat4xInstalledLocalContainer");
        this.registerContainer("tomcat4x", ContainerType.REMOTE, "org.codehaus.cargo.container.tomcat.Tomcat4xRemoteContainer");
        this.registerContainer("tomcat5x", ContainerType.INSTALLED, "org.codehaus.cargo.container.tomcat.Tomcat5xInstalledLocalContainer");
        this.registerContainer("tomcat5x", ContainerType.REMOTE, "org.codehaus.cargo.container.tomcat.Tomcat5xRemoteContainer");
        this.registerContainer("tomcat5x", ContainerType.EMBEDDED, "org.codehaus.cargo.container.tomcat.Tomcat5xEmbeddedLocalContainer");
        this.registerContainer("tomcat6x", ContainerType.INSTALLED, "org.codehaus.cargo.container.tomcat.Tomcat6xInstalledLocalContainer");
        this.registerContainer("tomcat6x", ContainerType.REMOTE, "org.codehaus.cargo.container.tomcat.Tomcat6xRemoteContainer");
    }

    public void registerWeblogic() {
        this.registerContainer("weblogic8x", ContainerType.INSTALLED, "org.codehaus.cargo.container.weblogic.WebLogic8xInstalledLocalContainer");
        this.registerContainer("weblogic9x", ContainerType.INSTALLED, "org.codehaus.cargo.container.weblogic.WebLogic9xInstalledLocalContainer");
        this.registerContainer("weblogic10x", ContainerType.INSTALLED, "org.codehaus.cargo.container.weblogic.WebLogic10xInstalledLocalContainer");
        this.registerContainer("weblogic103x", ContainerType.INSTALLED, "org.codehaus.cargo.container.weblogic.WebLogic103xInstalledLocalContainer");
    }

    public boolean isContainerRegistered(String containerId, ContainerType containerType) {
        return this.hasMapping(new RegistrationKey(new SimpleContainerIdentity(containerId), containerType.getType()));
    }

    public void registerContainer(String containerId, ContainerType containerType, Class containerClass) {
        this.registerImplementation(new RegistrationKey(new SimpleContainerIdentity(containerId), containerType.getType()), containerClass);
    }

    public void registerContainer(String containerId, ContainerType containerType, String containerClassName) {
        this.registerImplementation(new RegistrationKey(new SimpleContainerIdentity(containerId), containerType.getType()), containerClassName);
    }

    public Class getContainerClass(String containerId, ContainerType containerType) {
        return this.getMapping(new RegistrationKey(new SimpleContainerIdentity(containerId), containerType.getType()));
    }

    public Container createContainer(String containerId, ContainerType containerType, Configuration configuration) {
        ContainerFactoryParameters parameters = new ContainerFactoryParameters();
        parameters.configuration = configuration;
        return (Container)this.createImplementation(new RegistrationKey(new SimpleContainerIdentity(containerId), containerType.getType()), parameters, "container");
    }

    protected Constructor getConstructor(Class containerClass, String containerType, AbstractGenericHintFactory.GenericParameters parameters) throws NoSuchMethodException {
        Constructor constructor;
        ContainerType type = ContainerType.toType((String)containerType);
        if (type.isLocal()) {
            constructor = containerClass.getConstructor(LocalConfiguration.class);
        } else if (type.isRemote()) {
            constructor = containerClass.getConstructor(RuntimeConfiguration.class);
        } else {
            throw new ContainerException("Unknown container type [" + type.getType() + "]");
        }
        return constructor;
    }

    protected Object createInstance(Constructor constructor, String containerType, AbstractGenericHintFactory.GenericParameters parameters) throws Exception {
        Configuration configuration = ((ContainerFactoryParameters)parameters).configuration;
        return constructor.newInstance(configuration);
    }

    public Map getContainerIds() {
        HashMap containerIds = new HashMap();
        Iterator keys = this.getMappings().keySet().iterator();
        while (keys.hasNext()) {
            Set<ContainerType> hints;
            RegistrationKey key = (RegistrationKey)keys.next();
            SimpleContainerIdentity identity = (SimpleContainerIdentity)key.getContainerIdentity();
            if (containerIds.containsKey(identity.getId())) {
                hints = (Set)containerIds.get(identity.getId());
                hints.add(ContainerType.toType((String)key.getHint()));
                continue;
            }
            hints = new HashSet<ContainerType>();
            hints.add(ContainerType.toType((String)key.getHint()));
            containerIds.put(identity.getId(), hints);
        }
        return containerIds;
    }

    private static class ContainerFactoryParameters
    implements AbstractGenericHintFactory.GenericParameters {
        public Configuration configuration;

        private ContainerFactoryParameters() {
        }
    }
}

