/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.spi.jvm;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.RedirectorElement;
import org.codehaus.cargo.container.internal.AntContainerExecutorThread;
import org.codehaus.cargo.container.spi.jvm.JvmLauncher;
import org.codehaus.cargo.container.spi.jvm.JvmLauncherException;

class DefaultJvmLauncher
implements JvmLauncher {
    private final Java java;
    private boolean spawn;
    private final Map<String, String> environmentVariables = new HashMap<String, String>();

    public DefaultJvmLauncher(Java java) {
        this.java = java;
    }

    @Override
    public void setWorkingDirectory(File workingDirectory) {
        this.java.setDir(workingDirectory);
    }

    @Override
    public void setJvm(String command) {
        this.java.setJvm(command);
    }

    @Override
    public void addJvmArgument(File file) {
        if (file != null) {
            this.java.createJvmarg().setFile(file);
        }
    }

    @Override
    public void addJvmArguments(String ... values) {
        if (values != null) {
            for (String value : values) {
                this.java.createJvmarg().setValue(value);
            }
        }
    }

    @Override
    public void addJvmArgumentLine(String line) {
        if (line != null) {
            this.java.createJvmarg().setLine(line);
        }
    }

    @Override
    public void addClasspathEntries(String ... paths) {
        if (paths != null) {
            Path cp = this.java.createClasspath();
            for (String path : paths) {
                cp.createPathElement().setPath(path);
            }
        }
    }

    @Override
    public void addClasspathEntries(File ... paths) {
        if (paths != null) {
            Path cp = this.java.createClasspath();
            for (File path : paths) {
                cp.createPathElement().setLocation(path);
            }
        }
    }

    @Override
    public String getClasspath() {
        Path p = this.java.getCommandLine().getClasspath();
        return p != null ? p.toString() : "";
    }

    @Override
    public void setSystemProperty(String name, String value) {
        if (name != null && !name.isEmpty()) {
            Environment.Variable var = new Environment.Variable();
            var.setKey(name);
            var.setValue(value != null ? value : "");
            this.java.addSysproperty(var);
        }
    }

    @Override
    public void setEnvironmentVariable(String name, String value) {
        if (name != null && !name.isEmpty()) {
            Environment.Variable var = new Environment.Variable();
            var.setKey(name);
            var.setValue(value);
            this.java.addEnv(var);
            this.environmentVariables.put(name, value);
        }
    }

    @Override
    public String getEnvironmentVariable(String name) {
        String value = this.environmentVariables.get(name);
        if (value == null) {
            value = System.getenv(name);
        }
        return value;
    }

    @Override
    public void setJarFile(File jarFile) {
        if (jarFile != null) {
            this.java.setJar(jarFile);
        }
    }

    @Override
    public void setMainClass(String mainClass) {
        if (mainClass != null) {
            this.java.setClassname(mainClass);
        }
    }

    @Override
    public void addAppArgument(File file) {
        if (file != null) {
            this.java.createArg().setFile(file);
        }
    }

    @Override
    public void addAppArguments(String ... values) {
        if (values != null) {
            for (String value : values) {
                this.java.createArg().setValue(value);
            }
        }
    }

    @Override
    public void addAppArgumentLine(String line) {
        if (line != null) {
            this.java.createArg().setLine(line);
        }
    }

    @Override
    public void setOutputFile(File outputFile) {
        this.java.setOutput(outputFile);
        this.java.setError(outputFile);
        RedirectorElement redirector = new RedirectorElement();
        redirector.setCreateEmptyFiles(false);
        this.java.addConfiguredRedirector(redirector);
    }

    @Override
    public void setAppendOutput(boolean appendOutput) {
        this.java.setAppend(appendOutput);
    }

    @Override
    public String getCommandLine() {
        return this.java.getCommandLine().toString();
    }

    @Override
    public void kill() {
    }

    @Override
    public void setTimeout(long millis) {
        if (millis > 0L) {
            this.java.setTimeout(Long.valueOf(millis));
        } else {
            this.java.setTimeout(null);
        }
    }

    @Override
    public void setSpawn(boolean spawn) {
        this.spawn = spawn;
    }

    @Override
    public void start() throws JvmLauncherException {
        AntContainerExecutorThread runner = new AntContainerExecutorThread(this.java, this.spawn);
        runner.start();
    }

    @Override
    public int execute() throws JvmLauncherException {
        try {
            return this.java.executeJava();
        }
        catch (BuildException e) {
            throw new JvmLauncherException(e.getMessage(), e);
        }
    }
}

