/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.spi;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Map;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.State;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.deployer.URLDeployableMonitor;
import org.codehaus.cargo.container.spi.AbstractContainer;
import org.codehaus.cargo.container.spi.deployer.DeployerWatchdog;
import org.codehaus.cargo.container.spi.util.ContainerUtils;
import org.codehaus.cargo.container.startup.ContainerMonitor;
import org.codehaus.cargo.util.CargoException;
import org.codehaus.cargo.util.DefaultFileHandler;
import org.codehaus.cargo.util.FileHandler;

public abstract class AbstractLocalContainer
extends AbstractContainer
implements LocalContainer {
    private String output;
    private boolean append = false;
    private long timeout = 120000L;
    private LocalConfiguration configuration;
    private State state = State.UNKNOWN;
    private FileHandler fileHandler;

    public AbstractLocalContainer(LocalConfiguration configuration) {
        this.configuration = configuration;
        this.fileHandler = new DefaultFileHandler();
    }

    @Override
    public void setOutput(String output) {
        this.output = output;
    }

    @Override
    public void setAppend(boolean isAppend) {
        this.append = isAppend;
    }

    @Override
    public String getOutput() {
        return this.output;
    }

    @Override
    public boolean isAppend() {
        return this.append;
    }

    protected void verify() {
    }

    protected abstract void startInternal() throws Exception;

    protected abstract void stopInternal() throws Exception;

    protected void forceStopInternal() {
    }

    protected void executePostStartTasks() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void start() {
        AbstractLocalContainer abstractLocalContainer = this;
        synchronized (abstractLocalContainer) {
            if (State.STARTING == this.getState() || State.STARTED == this.getState()) {
                throw new ContainerException("The container is already " + this.getState() + ". If you wish to restart a running container, please use the restart method instead.");
            }
            this.setState(State.STARTING);
        }
        this.getLogger().info(this.getName() + " starting...", this.getClass().getName());
        try {
            this.getConfiguration().applyPortOffset();
            this.verify();
            this.getConfiguration().configure(this);
            for (Map.Entry entry : this.getConfiguration().getProperties().entrySet()) {
                if (!((String)entry.getKey()).startsWith("cargo.") || !((String)entry.getKey()).endsWith(".port") || entry.getValue() == null) continue;
                try {
                    int port = Integer.parseInt((String)entry.getValue());
                    if (this.isPortShutdown(port, 0)) continue;
                    throw new ContainerException("Port number " + (String)entry.getValue() + " (defined with the property " + (String)entry.getKey() + ") is in use. Please free it on the system or set it to a different port in the container configuration.");
                }
                catch (NumberFormatException numberFormatException) {
                }
            }
            this.startInternal();
            if (this.getTimeout() != 0L) {
                this.waitForCompletion(true);
            }
            this.executePostStartTasks();
            this.setState(State.STARTED);
            this.getLogger().info(this.getName() + " started on port [" + this.getConfiguration().getPropertyValue("cargo.servlet.port") + "]", this.getClass().getName());
        }
        catch (CargoException e) {
            this.setState(State.UNKNOWN);
            this.getLogger().warn(e.toString(), this.getClass().getName());
            throw e;
        }
        catch (Throwable t) {
            this.setState(State.UNKNOWN);
            this.getLogger().warn(t.toString(), this.getClass().getName());
            throw new ContainerException("Failed to start the " + this.getName() + " container." + (this.getOutput() == null ? "" : " Check the [" + this.getOutput() + "] file containing the container logs for more details."), t);
        }
        finally {
            this.getConfiguration().revertPortOffset();
        }
    }

    @Override
    public final void stop() {
        this.setState(State.STOPPING);
        this.getLogger().info(this.getName() + " is stopping...", this.getClass().getName());
        boolean isAppend = this.isAppend();
        try {
            this.getConfiguration().applyPortOffset();
            this.verify();
            this.setAppend(true);
            this.stopInternal();
            if (this.getTimeout() != 0L) {
                this.waitForCompletion(false);
            }
            this.forceStopInternal();
            this.setState(State.STOPPED);
            this.getLogger().info(this.getName() + " is stopped", this.getClass().getName());
        }
        catch (Exception e) {
            this.setState(State.UNKNOWN);
            throw new ContainerException("Failed to stop the " + this.getName() + " container." + (this.getOutput() == null ? "" : " Check the [" + this.getOutput() + "] file containing the container logs for more details."), e);
        }
        finally {
            this.setAppend(isAppend);
            this.getConfiguration().revertPortOffset();
        }
    }

    @Override
    public void restart() {
        try {
            this.stop();
        }
        catch (Throwable t) {
            this.getLogger().info("The stop phase of the restart action has failed: " + t.toString(), this.getClass().getName());
        }
        this.start();
    }

    protected void waitForStarting(ContainerMonitor monitor) throws InterruptedException {
        try {
            long startTime = System.currentTimeMillis();
            do {
                if (System.currentTimeMillis() - startTime > this.getTimeout()) {
                    String message = "Monitor [" + monitor.getClass().getName() + "] failed to detect running container within the timeout period [" + this.getTimeout() + "].";
                    this.getLogger().info(message, this.getClass().getName());
                    throw new ContainerException(message);
                }
                Thread.sleep(100L);
            } while (!monitor.isRunning());
        }
        catch (InterruptedException e) {
            throw new ContainerException("Failed to monitor container", e);
        }
    }

    protected void waitForCompletion(boolean waitForStarting) throws InterruptedException {
        LocalConfiguration config = this.getConfiguration();
        if (waitForStarting) {
            URLDeployableMonitor monitor = new URLDeployableMonitor(ContainerUtils.getCPCURL(config), this.getTimeout(), "Cargo Ping Component used to verify if the container is started.");
            monitor.setLogger(this.getLogger());
            DeployerWatchdog watchdog = new DeployerWatchdog(monitor);
            watchdog.setLogger(this.getLogger());
            watchdog.watch(waitForStarting);
        } else {
            long deadline = System.currentTimeMillis() + this.getTimeout();
            int connectTimeout = 0;
            for (Map.Entry<String, String> property : this.getConfiguration().getProperties().entrySet()) {
                int port;
                if (!property.getKey().startsWith("cargo.") || !property.getKey().endsWith(".port") || property.getValue() == null) continue;
                try {
                    port = Integer.parseInt(property.getValue());
                }
                catch (NumberFormatException e) {
                    continue;
                }
                if (port < 1 || port > 65535) continue;
                this.waitForPortShutdown(port, connectTimeout, deadline);
                this.getLogger().debug("\tPort " + port + " is shutdown", this.getClass().getName());
                connectTimeout = 250;
            }
            Thread.sleep(5000L);
        }
    }

    protected void waitForPortShutdown(int port, int connectTimeout, long deadline) throws InterruptedException {
        this.getLogger().debug("Waiting for port " + port + " to shutdown, deadline " + deadline, this.getClass().getName());
        while (!this.isPortShutdown(port, connectTimeout)) {
            if (System.currentTimeMillis() > deadline) {
                throw new ContainerException("Server port " + port + " did not shutdown within the timeout period [" + this.getTimeout() + "]");
            }
            Thread.sleep(1000L);
        }
    }

    @Override
    public void setConfiguration(LocalConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public LocalConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    @Override
    public long getTimeout() {
        return this.timeout;
    }

    @Override
    public State getState() {
        return this.state;
    }

    protected void setState(State state) {
        this.state = state;
    }

    @Override
    public FileHandler getFileHandler() {
        return this.fileHandler;
    }

    @Override
    public void setFileHandler(FileHandler fileHandler) {
        this.fileHandler = fileHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isPortShutdown(int port, int connectTimeout) {
        Socket s = new Socket();
        try {
            this.getLogger().debug("\tConnection attempt with socket " + s + ", current time is " + System.currentTimeMillis(), this.getClass().getName());
            s.bind(null);
            s.connect(new InetSocketAddress("localhost", port), connectTimeout);
            this.getLogger().debug("\tSocket " + s + " for port " + port + " managed to connect", this.getClass().getName());
            try {
                s.shutdownOutput();
            }
            catch (IOException e) {
                this.getLogger().debug("\tFailed to shutdown output for socket " + s + ": " + e, this.getClass().getName());
            }
            try {
                s.shutdownInput();
            }
            catch (IOException e) {
                this.getLogger().debug("\tFailed to shutdown input for socket " + s + ": " + e, this.getClass().getName());
            }
            this.getLogger().debug("\tSocket " + s + " for port " + port + " shutdown", this.getClass().getName());
            return false;
        }
        catch (IOException ignored) {
            boolean bl = true;
            return bl;
        }
        finally {
            try {
                s.close();
            }
            catch (IOException e) {
                this.getLogger().debug("\tFailed to close socket " + s + ": " + e, this.getClass().getName());
            }
            finally {
                this.getLogger().debug("\tSocket " + s + " for port " + port + " closed", this.getClass().getName());
                s = null;
                System.gc();
            }
        }
    }
}

