/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.configuration.entry;

import java.util.Arrays;
import java.util.Properties;
import org.codehaus.cargo.container.property.TransactionSupport;

public class DataSource {
    private String jndiLocation;
    private String connectionType;
    private TransactionSupport transactionSupport;
    private String driverClass;
    private String url;
    private String username;
    private String password;
    private String id;
    private Properties connectionProperties;

    public DataSource() {
        this.connectionProperties = new Properties();
    }

    public DataSource(String jndiLocation, String connectionType, TransactionSupport transactionSupport, String driverClass, String url, String username, String password, String id, Properties connectionProperties) {
        this.jndiLocation = jndiLocation;
        this.connectionType = this.createConnectionType(connectionType);
        this.transactionSupport = this.createTransactionSupport(transactionSupport, this.connectionType);
        this.driverClass = driverClass;
        this.url = url;
        this.username = username;
        this.password = password;
        this.id = id == null && jndiLocation != null ? this.createIdFromJndiLocation(jndiLocation) : id;
        this.connectionProperties = connectionProperties;
        this.setCredentialsIfInsideDriverProperties();
    }

    public void setJndiLocation(String jndiLocation) {
        this.jndiLocation = jndiLocation;
    }

    public void setConnectionType(String connectionType) {
        this.connectionType = connectionType;
    }

    public void setTransactionSupport(TransactionSupport transactionSupport) {
        this.transactionSupport = transactionSupport;
    }

    public void setDriverClass(String driverClass) {
        this.driverClass = driverClass;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setConnectionProperties(Properties connectionProperties) {
        this.connectionProperties = connectionProperties;
    }

    public String getId() {
        return this.id;
    }

    public String getJndiLocation() {
        return this.jndiLocation;
    }

    public String getConnectionType() {
        return this.connectionType;
    }

    public TransactionSupport getTransactionSupport() {
        return this.transactionSupport;
    }

    public String getDriverClass() {
        return this.driverClass;
    }

    public Properties getConnectionProperties() {
        return this.connectionProperties;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    private String createConnectionType(String connectionType) {
        if ("javax.sql.XADataSource".equals(connectionType)) {
            return "javax.sql.XADataSource";
        }
        if ("javax.sql.DataSource".equals(connectionType)) {
            return "javax.sql.DataSource";
        }
        return "java.sql.Driver";
    }

    private TransactionSupport createTransactionSupport(TransactionSupport transactionSupport, String connectionType) {
        if (TransactionSupport.XA_TRANSACTION.equals(transactionSupport) || "javax.sql.XADataSource".equals(connectionType)) {
            return TransactionSupport.XA_TRANSACTION;
        }
        if (TransactionSupport.LOCAL_TRANSACTION.equals(transactionSupport)) {
            return TransactionSupport.LOCAL_TRANSACTION;
        }
        return TransactionSupport.NO_TRANSACTION;
    }

    private String createIdFromJndiLocation(String jndiLocation) {
        int[] delimeters = new int[]{jndiLocation.lastIndexOf(47), jndiLocation.lastIndexOf(46), jndiLocation.lastIndexOf(58)};
        Arrays.sort(delimeters);
        int highestIndex = delimeters[2];
        return jndiLocation.substring(highestIndex + 1);
    }

    private void setCredentialsIfInsideDriverProperties() {
        if (this.getConnectionProperties() != null) {
            if (this.getConnectionProperties().containsKey("user")) {
                this.setUsername(this.getConnectionProperties().getProperty("user"));
            }
            if (this.getConnectionProperties().containsKey("password")) {
                this.setPassword(this.getConnectionProperties().getProperty("password"));
            }
        }
    }
}

