/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.spi.deployer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.container.deployable.EAR;
import org.codehaus.cargo.container.deployable.RAR;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.container.spi.deployer.AbstractInstalledLocalDeployer;
import org.codehaus.cargo.util.CargoException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCopyingInstalledLocalDeployer
extends AbstractInstalledLocalDeployer {
    private Set<DeployableType> doNotDeployExpanded = new HashSet<DeployableType>();
    private List<Deployable> deployedDeployables = new ArrayList<Deployable>();

    public AbstractCopyingInstalledLocalDeployer(LocalContainer container) {
        super(container);
    }

    public void setShouldDeployExpanded(DeployableType type, boolean flag) {
        if (flag) {
            this.doNotDeployExpanded.remove(type);
        } else {
            this.doNotDeployExpanded.add(type);
        }
    }

    protected boolean shouldDeployExpanded(DeployableType type) {
        return !this.doNotDeployExpanded.contains(type);
    }

    @Override
    public synchronized void deploy(Deployable deployable) {
        if (!this.canBeDeployed(deployable)) {
            throw new ContainerException("Failed to deploy [" + deployable.getFile() + "] to [" + this.getDeployableDir(deployable) + "]. The required web context is already in use" + " by another application.");
        }
        if (!this.getContainer().getCapability().supportsDeployableType(deployable.getType())) {
            throw new ContainerException(deployable.getType().getType().toUpperCase() + " archives are not supported for deployment in [" + this.getContainer().getId() + "]. Got [" + deployable.getFile() + "]");
        }
        String deployableDir = this.getDeployableDir(deployable);
        try {
            if (deployable.isExpanded()) {
                if (!this.shouldDeployExpanded(deployable.getType())) {
                    throw new ContainerException("Container " + this.getContainer().getName() + " cannot deploy expanded " + deployable.getType() + " deployables");
                }
                if (!this.getFileHandler().isDirectory(deployable.getFile())) {
                    throw new ContainerException("The deployable's file " + deployable.getFile() + " is not a directory, hence cannot be deployed as expanded");
                }
            }
            this.doDeploy(deployableDir, deployable);
        }
        catch (Exception e) {
            throw new ContainerException("Failed to deploy [" + deployable.getFile() + "] to [" + deployableDir + "]", e);
        }
        this.deployedDeployables.add(deployable);
    }

    protected boolean canBeDeployed(Deployable newDeployable) {
        Set<String> newDeployableContextSet = AbstractCopyingInstalledLocalDeployer.getWebContextsSet(newDeployable);
        for (Deployable deployedDeployable : this.deployedDeployables) {
            for (String webContext : AbstractCopyingInstalledLocalDeployer.getWebContexts(deployedDeployable)) {
                if (!newDeployableContextSet.contains(webContext)) continue;
                return false;
            }
        }
        return true;
    }

    private static List<String> getWebContexts(Deployable deployable) {
        List<String> webContexts = deployable.getType() == DeployableType.EAR ? ((EAR)deployable).getWebContexts() : (deployable.getType() == DeployableType.WAR ? Arrays.asList(((WAR)deployable).getContext()) : Collections.emptyList());
        return webContexts;
    }

    private static Set<String> getWebContextsSet(Deployable deployable) {
        HashSet<String> webContextSet = new HashSet<String>();
        for (String webContext : AbstractCopyingInstalledLocalDeployer.getWebContexts(deployable)) {
            webContextSet.add(webContext);
        }
        return webContextSet;
    }

    public abstract String getDeployableDir(Deployable var1);

    protected void doDeploy(String deployableDir, Deployable deployable) {
        this.getLogger().info("Deploying [" + deployable.getFile() + "] to [" + deployableDir + "]...", this.getClass().getName());
        if (!this.getFileHandler().isDirectory(deployableDir)) {
            throw new CargoException("Target deployable directory does not exist: " + deployableDir);
        }
        String target = this.getFileHandler().append(deployableDir, this.getDeployableName(deployable));
        if (deployable.isExpanded()) {
            if (this.getFileHandler().exists(target) && !this.getFileHandler().isDirectory(target)) {
                this.getFileHandler().delete(target);
            }
            this.getFileHandler().copyDirectory(deployable.getFile(), target);
        } else {
            if (this.getFileHandler().exists(target) && this.getFileHandler().isDirectory(target)) {
                this.getFileHandler().delete(target);
            }
            this.getFileHandler().copyFile(deployable.getFile(), target, true);
        }
    }

    protected String getDeployableName(Deployable deployable) {
        String deployableName;
        if (DeployableType.WAR.equals(deployable.getType())) {
            WAR war = (WAR)deployable;
            String context = war.getContext();
            if ("".equals(context) || "/".equals(context)) {
                this.getLogger().info("The WAR file has its context set to / and will therefore be deployed as ROOT.war", this.getClass().getName());
                context = "ROOT";
            }
            deployableName = war.isExpanded() ? context : context + ".war";
        } else if (DeployableType.EAR.equals(deployable.getType())) {
            EAR ear = (EAR)deployable;
            String earName = ear.getName();
            if (earName == null || "".equals(earName)) {
                earName = this.getFileHandler().getName(ear.getFile());
            }
            if (!earName.toLowerCase().endsWith(".ear")) {
                earName = earName + ".ear";
            }
            deployableName = earName;
        } else if (DeployableType.RAR.equals(deployable.getType())) {
            RAR rar = (RAR)deployable;
            String rarName = rar.getName();
            if (rarName == null || "".equals(rarName)) {
                rarName = this.getFileHandler().getName(rar.getFile());
            }
            if (!rarName.toLowerCase().endsWith(".rar")) {
                rarName = rarName + ".rar";
            }
            deployableName = rarName;
        } else {
            deployableName = this.getFileHandler().getName(deployable.getFile());
        }
        return deployableName;
    }
}

