/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.spi;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.apache.tools.ant.types.Path;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.ContainerType;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.internal.util.AntBuildListener;
import org.codehaus.cargo.container.internal.util.HttpUtils;
import org.codehaus.cargo.container.internal.util.JdkUtils;
import org.codehaus.cargo.container.internal.util.ResourceUtils;
import org.codehaus.cargo.container.spi.AbstractLocalContainer;
import org.codehaus.cargo.util.AntUtils;
import org.codehaus.cargo.util.log.Logger;

public abstract class AbstractInstalledLocalContainer
extends AbstractLocalContainer
implements InstalledLocalContainer {
    private Map systemProperties;
    private List extraClasspath;
    private List sharedClasspath;
    private String home;
    private JdkUtils jdkUtils = new JdkUtils();
    private AntUtils antUtils = new AntUtils();
    private HttpUtils httpUtils;
    private ResourceUtils resourceUtils = new ResourceUtils();

    public AbstractInstalledLocalContainer(LocalConfiguration configuration) {
        super(configuration);
        this.httpUtils = new HttpUtils();
        this.extraClasspath = new ArrayList();
        this.sharedClasspath = new ArrayList();
        this.systemProperties = new HashMap();
    }

    public void setLogger(Logger logger) {
        super.setLogger(logger);
        this.resourceUtils.setLogger(logger);
        this.httpUtils.setLogger(logger);
    }

    protected final HttpUtils getHttpUtils() {
        return this.httpUtils;
    }

    protected final JdkUtils getJdkUtils() {
        return this.jdkUtils;
    }

    protected final AntUtils getAntUtils() {
        return this.antUtils;
    }

    protected final ResourceUtils getResourceUtils() {
        return this.resourceUtils;
    }

    public final void setHome(String home) {
        this.home = home;
    }

    public void setSystemProperties(Map properties) {
        HashMap props = new HashMap();
        props.putAll(properties);
        this.systemProperties = props;
    }

    public Map getSystemProperties() {
        return this.systemProperties;
    }

    public void setExtraClasspath(String[] classpath) {
        this.extraClasspath.clear();
        this.extraClasspath.addAll(Arrays.asList(classpath));
    }

    public String[] getExtraClasspath() {
        return this.extraClasspath.toArray(new String[0]);
    }

    public void setSharedClasspath(String[] classpath) {
        this.sharedClasspath.clear();
        this.sharedClasspath.addAll(Arrays.asList(classpath));
    }

    public String[] getSharedClasspath() {
        return this.sharedClasspath.toArray(new String[0]);
    }

    public final String getHome() {
        return this.home;
    }

    protected abstract void doStart(Java var1) throws Exception;

    protected abstract void doStop(Java var1) throws Exception;

    protected final void startInternal() throws Exception {
        this.doStart(this.createJavaTask());
    }

    protected final void stopInternal() throws Exception {
        this.doStop(this.createJavaTask());
    }

    private Java createJavaTask() {
        Java java = (Java)this.getAntUtils().createAntTask("java");
        java.setFork(true);
        if (this.getOutput() != null) {
            File outputFile = new File(this.getOutput());
            outputFile.getParentFile().mkdirs();
            java.setOutput(outputFile);
            java.setAppend(this.isAppend());
        }
        java.getProject().addBuildListener((BuildListener)new AntBuildListener(this.getLogger(), this.getClass().getName()));
        this.setJvmToLaunchContainerIn(java);
        this.addExtraClasspath(java);
        this.addSystemProperties(java);
        String jvmargs = this.getConfiguration().getPropertyValue("cargo.jvmargs");
        if (jvmargs != null) {
            java.createJvmarg().setLine(jvmargs);
        }
        return java;
    }

    protected void setJvmToLaunchContainerIn(Java java) {
        String javaHome = this.getConfiguration().getPropertyValue("cargo.java.home");
        if (javaHome != null) {
            String binDir = this.getFileHandler().append(javaHome, "bin");
            String javaPath = this.getFileHandler().append(binDir, "java");
            if (Os.isFamily((String)"windows")) {
                javaPath = javaPath + ".exe";
            }
            java.setJvm(javaPath);
        }
    }

    private void addSystemProperties(Java java) {
        Iterator keys = this.getSystemProperties().keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            java.addSysproperty(this.getAntUtils().createSysProperty(key, (String)this.getSystemProperties().get(key)));
        }
    }

    protected final void addToolsJarToClasspath(Path classpath) throws FileNotFoundException {
        if (!this.getJdkUtils().isOSX()) {
            String javaHome = this.getConfiguration().getPropertyValue("cargo.java.home");
            if (javaHome == null) {
                classpath.createPathElement().setLocation(this.getJdkUtils().getToolsJar());
            } else {
                if (javaHome.indexOf("jre") > 0) {
                    javaHome = this.getFileHandler().getParent(javaHome);
                }
                String libDir = this.getFileHandler().append(javaHome, "lib");
                classpath.createPathElement().setLocation(new File(libDir, "tools.jar"));
            }
        }
    }

    private void addExtraClasspath(Java javaCommand) {
        Path classpath = javaCommand.createClasspath();
        if (this.extraClasspath.size() > 0) {
            Path path = new Path(this.getAntUtils().createProject());
            Iterator entries = this.extraClasspath.iterator();
            while (entries.hasNext()) {
                Path pathElement = new Path(this.getAntUtils().createProject(), (String)entries.next());
                path.addExisting(pathElement);
                this.getLogger().debug("Adding [" + pathElement + "] to execution classpath", this.getClass().getName());
            }
            classpath.addExisting(path);
        }
    }

    protected void verify() {
        super.verify();
        this.verifyHome();
    }

    private void verifyHome() {
        if (this.getHome() == null) {
            throw new ContainerException("You must set the mandatory [home] property");
        }
        if (!this.getFileHandler().isDirectory(this.getHome())) {
            throw new ContainerException("[" + this.getHome() + "] is not a directory. It must point " + "to the container home directory.");
        }
    }

    public ContainerType getType() {
        return ContainerType.INSTALLED;
    }

    public void addExtraClasspath(String location) {
        this.ifPresentAddPathToList(location, this.extraClasspath);
    }

    public void addSharedClasspath(String location) {
        this.ifPresentAddPathToList(location, this.sharedClasspath);
    }

    public void ifPresentAddPathToList(String location, List list) {
        if (location == null || !this.getFileHandler().exists(location)) {
            throw new IllegalArgumentException("Invalid file path: " + location);
        }
        list.add(location);
    }
}

