/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.internal.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Vector;
import org.apache.tools.ant.filters.util.ChainReaderHelper;
import org.apache.tools.ant.types.FilterChain;
import org.codehaus.cargo.util.DefaultFileHandler;
import org.codehaus.cargo.util.FileHandler;
import org.codehaus.cargo.util.log.LoggedObject;

public final class ResourceUtils
extends LoggedObject {
    private static FileHandler defaultFileHandler = new DefaultFileHandler();

    public void copyResource(String resourceName, File destFile) throws IOException {
        this.copyResource(resourceName, destFile.getPath(), defaultFileHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyResource(String resourceName, String destFile, FileHandler handler) throws IOException {
        InputStream in = ResourceUtils.class.getResourceAsStream(resourceName);
        if (in == null) {
            throw new IOException("Resource [" + resourceName + "] not found");
        }
        OutputStream out = null;
        try {
            int numBytes;
            out = handler.getOutputStream(destFile);
            byte[] buf = new byte[4096];
            while ((numBytes = in.read(buf)) > 0) {
                out.write(buf, 0, numBytes);
            }
        }
        finally {
            in.close();
            if (out != null) {
                out.close();
            }
        }
    }

    public void copyResource(String resourceName, File destFile, FilterChain filterChain) throws IOException {
        this.copyResource(resourceName, destFile.getPath(), defaultFileHandler, filterChain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyResource(String resourceName, String destFile, FileHandler handler, FilterChain filterChain) throws IOException {
        InputStream resource = ResourceUtils.class.getResourceAsStream(resourceName);
        if (resource == null) {
            throw new IOException("Resource [" + resourceName + "] not found");
        }
        BufferedReader in = null;
        BufferedWriter out = null;
        try {
            String line;
            ChainReaderHelper helper = new ChainReaderHelper();
            helper.setBufferSize(8192);
            helper.setPrimaryReader((Reader)new BufferedReader(new InputStreamReader(resource)));
            Vector<FilterChain> filterChains = new Vector<FilterChain>();
            filterChains.add(filterChain);
            helper.setFilterChains(filterChains);
            in = new BufferedReader(helper.getAssembledReader());
            out = new BufferedWriter(new OutputStreamWriter(handler.getOutputStream(destFile)));
            while ((line = in.readLine()) != null) {
                if (line.length() == 0) {
                    out.newLine();
                    continue;
                }
                out.write(line);
                out.newLine();
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    public File getResourceLocation(String resourceName) {
        File file = null;
        URL url = ResourceUtils.class.getResource(resourceName);
        if (url != null) {
            String urlString = url.toString();
            if (urlString.startsWith("jar:file:")) {
                int pling = urlString.indexOf("!");
                String jar = urlString.substring(9, pling);
                file = new File(URLDecoder.decode(jar));
            } else if (urlString.startsWith("file:")) {
                int tail = urlString.indexOf(resourceName);
                String dir = urlString.substring(5, tail);
                file = new File(URLDecoder.decode(dir));
            }
        }
        this.getLogger().debug("Location for [" + resourceName + "] is [" + file + "]", ((Object)((Object)this)).getClass().getName());
        return file;
    }
}

