/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.internal.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.tools.ant.util.StringUtils;

public final class PropertyUtils {
    private static final char PIPE = '|';
    private static final char SEMICOLON = ';';

    private PropertyUtils() {
    }

    public static Properties splitPropertiesOnPipe(String toSplit) {
        return PropertyUtils.splitPropertiesOnDelimiter(toSplit, '|');
    }

    public static Properties splitPropertiesOnSemicolon(String toSplit) {
        return PropertyUtils.splitPropertiesOnDelimiter(toSplit, ';');
    }

    public static Properties splitPropertiesOnDelimiter(String toSplit, char delimiter) {
        Properties properties = new Properties();
        String newLineSeparated = toSplit.replace(delimiter, '\n');
        try {
            properties.load(new ByteArrayInputStream(newLineSeparated.getBytes()));
            return properties;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IllegalArgumentException();
        }
    }

    public static String joinOnPipe(Map toJoin) {
        return PropertyUtils.joinOnDelimiter(toJoin, '|');
    }

    public static String joinOnSemicolon(Map toJoin) {
        return PropertyUtils.joinOnDelimiter(toJoin, ';');
    }

    public static String joinOnDelimiter(Map toJoin, char delimiter) {
        StringBuffer buf = new StringBuffer();
        Iterator it = toJoin.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry e = it.next();
            String key = (String)e.getKey();
            String value = (String)e.getValue();
            buf.append(key);
            buf.append("=");
            buf.append(value);
            if (!it.hasNext()) continue;
            buf.append(delimiter);
        }
        return buf.toString();
    }

    public static void setPropertyIfNotNull(Properties properties, String property, Object value) {
        if (value != null) {
            properties.setProperty(property, value.toString());
        }
    }

    public static String escapeBackSlashesIfNotNull(String in) {
        if (in != null) {
            return StringUtils.replace((String)in, (String)"\\", (String)"\\\\");
        }
        return null;
    }
}

