/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.installer;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.net.URL;
import org.apache.tools.ant.taskdefs.Expand;
import org.apache.tools.ant.taskdefs.Get;
import org.apache.tools.ant.taskdefs.Untar;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.installer.Installer;
import org.codehaus.cargo.container.installer.Proxy;
import org.codehaus.cargo.util.AntTaskFactory;
import org.codehaus.cargo.util.AntUtils;
import org.codehaus.cargo.util.DefaultFileHandler;
import org.codehaus.cargo.util.FileHandler;
import org.codehaus.cargo.util.log.LoggedObject;

public class ZipURLInstaller
extends LoggedObject
implements Installer {
    private static final String[] ARCHIVE_ENDINGS = new String[]{".zip", ".tgz", ".tar", ".bz2", ".tar.gz"};
    private URL remoteLocation;
    private String installDir;
    private Proxy proxy;
    private AntUtils antUtils;
    private FileHandler fileHandler;

    public ZipURLInstaller(URL remoteLocation) {
        this(remoteLocation, null);
    }

    public ZipURLInstaller(URL remoteLocation, String installDir) {
        this.remoteLocation = remoteLocation;
        this.installDir = installDir;
        this.fileHandler = new DefaultFileHandler();
        this.antUtils = new AntUtils();
    }

    public void setInstallDir(String installDir) {
        this.installDir = installDir;
    }

    protected void setAntTaskFactory(AntTaskFactory antTaskFactory) {
        this.antUtils = new AntUtils(antTaskFactory);
    }

    public FileHandler getFileHandler() {
        return this.fileHandler;
    }

    public void setFileHandler(FileHandler fileHandler) {
        this.fileHandler = fileHandler;
    }

    public void install() {
        if (!this.isAlreadyInstalled()) {
            this.getLogger().debug("Container [" + this.getSourceFileName() + "] is not yet installed.", this.getClass().getName());
            this.createDestinationDirectory();
            this.download();
            this.unpack();
            this.registerInstallation();
        } else {
            this.getLogger().debug("Container [" + this.getSourceFileName() + "] is already installed", this.getClass().getName());
            this.getLogger().debug("Using container installation dir [" + this.getDestinationDir() + "]", this.getClass().getName());
        }
    }

    public void registerInstallation() {
        try {
            File timestampFile = new File(this.getDestinationDir(), this.getInstallDirName() + "/.cargo");
            BufferedWriter bw = new BufferedWriter(new FileWriter(timestampFile));
            bw.write("Do not remove this file");
            bw.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isAlreadyInstalled() {
        boolean isInstalled = false;
        String timestampFile = this.getFileHandler().append(this.getDestinationDir(), this.getInstallDirName() + "/.cargo");
        if (this.getFileHandler().exists(timestampFile)) {
            isInstalled = true;
        }
        return isInstalled;
    }

    public String getHome() {
        if (!this.isAlreadyInstalled()) {
            throw new ContainerException("Failed to get container installation home as the container has not yet been installed. Please call install() first.");
        }
        String targetDir = this.getFileHandler().append(this.getDestinationDir(), this.getInstallDirName());
        String[] files = this.getFileHandler().getChildren(targetDir);
        int nbDirectories = 0;
        String foundDirectory = null;
        for (int i = 0; i < files.length; ++i) {
            if (!this.getFileHandler().isDirectory(files[i])) continue;
            ++nbDirectories;
            foundDirectory = files[i];
        }
        String home = nbDirectories != 1 ? targetDir : foundDirectory;
        return home;
    }

    private void unpack() {
        File targetDir = new File(this.getDestinationDir(), this.getInstallDirName());
        this.getLogger().info("Installing container in [" + targetDir.getPath() + "]", this.getClass().getName());
        Expand expandTask = this.createExpandTask();
        expandTask.setSrc(new File(this.getDestinationDir(), this.getSourceFileName()));
        expandTask.setDest(targetDir);
        expandTask.execute();
    }

    private Expand createExpandTask() {
        String archivename = this.getSourceFileName().toLowerCase();
        Expand expand = null;
        if (archivename.endsWith(".zip")) {
            expand = (Expand)this.antUtils.createAntTask("unzip");
        } else if (archivename.endsWith(".tar")) {
            expand = (Expand)this.antUtils.createAntTask("untar");
        } else if (archivename.endsWith(".tgz") || archivename.endsWith(".tar.gz")) {
            Untar untar = (Untar)this.antUtils.createAntTask("untar");
            Untar.UntarCompressionMethod compressionMethod = new Untar.UntarCompressionMethod();
            compressionMethod.setValue("gzip");
            untar.setCompression(compressionMethod);
            expand = untar;
        } else if (archivename.endsWith(".bz2")) {
            Untar untar = (Untar)this.antUtils.createAntTask("untar");
            Untar.UntarCompressionMethod compressionMethod = new Untar.UntarCompressionMethod();
            compressionMethod.setValue("bzip2");
            untar.setCompression(compressionMethod);
            expand = untar;
        } else {
            String errorMessage = "Unsupported archive type: [" + archivename + "]";
            this.getLogger().warn(errorMessage, this.getClass().getName());
            throw new IllegalArgumentException(errorMessage);
        }
        return expand;
    }

    protected void download() {
        try {
            if (this.proxy != null) {
                this.proxy.configure();
            }
            this.doDownload();
        }
        catch (Exception e) {
            if (this.proxy != null) {
                try {
                    this.proxy.clear();
                    this.doDownload();
                }
                catch (Exception ee) {
                    throw new ContainerException("Failed to download [" + this.remoteLocation + "]", ee);
                }
            }
            throw new ContainerException("Failed to download [" + this.remoteLocation + "]", e);
        }
    }

    private void doDownload() {
        this.getLogger().info("Downloading container from [" + this.remoteLocation + "]", this.getClass().getName());
        Get getTask = (Get)this.antUtils.createAntTask("get");
        getTask.setUseTimestamp(true);
        getTask.setSrc(this.remoteLocation);
        getTask.setDest(new File(this.getDestinationDir(), this.getSourceFileName()));
        getTask.execute();
    }

    protected String getSourceFileName() {
        int slashPos = this.remoteLocation.getPath().lastIndexOf(47);
        String name = this.remoteLocation.getPath();
        if (slashPos > -1) {
            name = this.remoteLocation.getPath().substring(slashPos + 1);
        }
        return name;
    }

    protected String getInstallDirName() {
        String name = this.getSourceFileName();
        for (int i = 0; i < ARCHIVE_ENDINGS.length; ++i) {
            int dotPos = name.lastIndexOf(ARCHIVE_ENDINGS[i]);
            if (dotPos <= -1) continue;
            name = name.substring(0, dotPos);
            break;
        }
        return name;
    }

    private void createDestinationDirectory() {
        String destinationDir = this.getDestinationDir();
        if (!this.getFileHandler().exists(destinationDir)) {
            this.getFileHandler().mkdirs(destinationDir);
        }
    }

    protected String getDestinationDir() {
        String dir = this.installDir;
        if (dir == null) {
            dir = this.getFileHandler().getTmpPath("installs");
        }
        return dir;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }
}

