/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.upcasting;

import java.util.ArrayList;
import java.util.List;
import org.axonframework.domain.DomainEventMessage;
import org.axonframework.serializer.SerializedDomainEventData;
import org.axonframework.serializer.SerializedDomainEventMessage;
import org.axonframework.serializer.SerializedObject;
import org.axonframework.serializer.Serializer;
import org.axonframework.serializer.UnknownSerializedTypeException;
import org.axonframework.upcasting.SerializedDomainEventUpcastingContext;
import org.axonframework.upcasting.UpcastSerializedDomainEventData;
import org.axonframework.upcasting.UpcasterChain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UpcastUtils {
    private static final Logger logger = LoggerFactory.getLogger(UpcastUtils.class);

    private UpcastUtils() {
    }

    public static List<DomainEventMessage> upcastAndDeserialize(SerializedDomainEventData entry, Object aggregateIdentifier, Serializer serializer, UpcasterChain upcasterChain, boolean skipUnknownTypes) {
        SerializedDomainEventUpcastingContext context = new SerializedDomainEventUpcastingContext(entry, serializer);
        List<SerializedObject> objects = upcasterChain.upcast(entry.getPayload(), context);
        ArrayList<DomainEventMessage> events = new ArrayList<DomainEventMessage>(objects.size());
        for (SerializedObject object : objects) {
            try {
                DomainEventMessage message = new SerializedDomainEventMessage(new UpcastSerializedDomainEventData(entry, UpcastUtils.firstNonNull(aggregateIdentifier, entry.getAggregateIdentifier()), object), serializer);
                if (context.getSerializedMetaData().isDeserialized()) {
                    message = message.withMetaData(context.getSerializedMetaData().getObject());
                }
                events.add(message);
            }
            catch (UnknownSerializedTypeException e) {
                if (!skipUnknownTypes) {
                    throw e;
                }
                logger.info("Ignoring event of unknown type {} (rev. {}), as it cannot be resolved to a Class", (Object)object.getType().getName(), (Object)object.getType().getRevision());
            }
        }
        return events;
    }

    private static Object firstNonNull(Object ... instances) {
        for (Object instance : instances) {
            if (instance == null) continue;
            return instance;
        }
        return null;
    }
}

