/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.upcasting;

import org.axonframework.domain.MetaData;
import org.axonframework.serializer.LazyDeserializingObject;
import org.axonframework.serializer.SerializedDomainEventData;
import org.axonframework.serializer.Serializer;
import org.axonframework.upcasting.UpcastingContext;
import org.joda.time.DateTime;

public class SerializedDomainEventUpcastingContext
implements UpcastingContext {
    private final String messageIdentifier;
    private final Object aggregateIdentifier;
    private final Long sequenceNumber;
    private final DateTime timestamp;
    private final LazyDeserializingObject<MetaData> serializedMetaData;

    public SerializedDomainEventUpcastingContext(SerializedDomainEventData domainEventData, Serializer serializer) {
        this.messageIdentifier = domainEventData.getEventIdentifier();
        this.aggregateIdentifier = domainEventData.getAggregateIdentifier();
        this.sequenceNumber = domainEventData.getSequenceNumber();
        this.timestamp = domainEventData.getTimestamp();
        this.serializedMetaData = new LazyDeserializingObject(domainEventData.getMetaData(), serializer);
    }

    @Override
    public String getMessageIdentifier() {
        return this.messageIdentifier;
    }

    @Override
    public Object getAggregateIdentifier() {
        return this.aggregateIdentifier;
    }

    @Override
    public Long getSequenceNumber() {
        return this.sequenceNumber;
    }

    @Override
    public DateTime getTimestamp() {
        return this.timestamp;
    }

    @Override
    public MetaData getMetaData() {
        return this.serializedMetaData.getObject();
    }

    public LazyDeserializingObject<MetaData> getSerializedMetaData() {
        return this.serializedMetaData;
    }
}

