/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.unitofwork;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.axonframework.domain.EventMessage;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.unitofwork.CurrentUnitOfWork;
import org.axonframework.unitofwork.UnitOfWork;
import org.axonframework.unitofwork.UnitOfWorkListenerAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NestableUnitOfWork
implements UnitOfWork {
    private static final Logger logger = LoggerFactory.getLogger(NestableUnitOfWork.class);
    private boolean isStarted;
    private UnitOfWork outerUnitOfWork;
    private final List<NestableUnitOfWork> innerUnitsOfWork = new ArrayList<NestableUnitOfWork>();
    private boolean isCommitted = false;
    private final Map<String, Object> resources = new HashMap<String, Object>();
    private final Map<String, Object> inheritedResources = new HashMap<String, Object>();

    @Override
    public void commit() {
        logger.debug("Committing Unit Of Work");
        this.assertStarted();
        try {
            this.notifyListenersPrepareCommit();
            this.saveAggregates();
            this.isCommitted = true;
            if (this.outerUnitOfWork == null) {
                logger.debug("This Unit Of Work is not nested. Finalizing commit...");
                this.doCommit();
                this.stop();
                this.performCleanup();
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug("This Unit Of Work is nested. Commit will be finalized by outer Unit Of Work.");
                }
                this.registerScheduledEvents(this.outerUnitOfWork);
            }
        }
        catch (RuntimeException e) {
            logger.debug("An error occurred while committing this UnitOfWork. Performing rollback...", (Throwable)e);
            this.doRollback(e);
            this.stop();
            if (this.outerUnitOfWork == null) {
                this.performCleanup();
            }
            throw e;
        }
        finally {
            logger.debug("Clearing resources of this Unit Of Work.");
            this.clear();
        }
    }

    protected abstract void registerScheduledEvents(UnitOfWork var1);

    private void performCleanup() {
        for (NestableUnitOfWork uow : this.innerUnitsOfWork) {
            uow.performCleanup();
        }
        this.notifyListenersCleanup();
    }

    protected abstract void notifyListenersCleanup();

    protected abstract void notifyListenersRollback(Throwable var1);

    @Override
    public void rollback() {
        this.rollback(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(Throwable cause) {
        if (cause != null && logger.isInfoEnabled()) {
            logger.debug("Rollback requested for Unit Of Work due to exception. ", cause);
        } else if (logger.isInfoEnabled()) {
            logger.debug("Rollback requested for Unit Of Work for unknown reason.");
        }
        try {
            if (this.isStarted()) {
                for (NestableUnitOfWork inner : this.innerUnitsOfWork) {
                    CurrentUnitOfWork.set(inner);
                    inner.rollback(cause);
                }
                this.doRollback(cause);
            }
        }
        finally {
            if (this.outerUnitOfWork == null) {
                this.performCleanup();
            }
            this.clear();
            this.stop();
        }
    }

    @Override
    public void start() {
        logger.debug("Starting Unit Of Work.");
        if (this.isStarted) {
            throw new IllegalStateException("UnitOfWork is already started");
        }
        this.doStart();
        if (CurrentUnitOfWork.isStarted()) {
            this.outerUnitOfWork = CurrentUnitOfWork.get();
            this.outerUnitOfWork.attachInheritedResources(this);
            if (this.outerUnitOfWork instanceof NestableUnitOfWork) {
                ((NestableUnitOfWork)this.outerUnitOfWork).registerInnerUnitOfWork(this);
            } else {
                this.outerUnitOfWork.registerListener(new CommitOnOuterCommitTask());
            }
        }
        logger.debug("Registering Unit Of Work as CurrentUnitOfWork");
        CurrentUnitOfWork.set(this);
        this.isStarted = true;
    }

    @Override
    public void publishEvent(EventMessage<?> event, EventBus eventBus) {
        this.registerForPublication(event, eventBus, !this.isCommitted);
    }

    protected abstract void registerForPublication(EventMessage<?> var1, EventBus var2, boolean var3);

    @Override
    public boolean isStarted() {
        return this.isStarted;
    }

    private void stop() {
        logger.debug("Stopping Unit Of Work");
        this.isStarted = false;
    }

    protected abstract void doStart();

    protected abstract void doCommit();

    protected abstract void doRollback(Throwable var1);

    private void performInnerCommit() {
        logger.debug("Finalizing commit of inner Unit Of Work...");
        CurrentUnitOfWork.set(this);
        try {
            this.doCommit();
        }
        catch (RuntimeException t) {
            this.doRollback(t);
            throw t;
        }
        finally {
            this.clear();
            this.stop();
        }
    }

    private void assertStarted() {
        if (!this.isStarted) {
            throw new IllegalStateException("UnitOfWork is not started");
        }
    }

    private void clear() {
        CurrentUnitOfWork.clear(this);
    }

    protected void commitInnerUnitOfWork() {
        for (int i = 0; i < this.innerUnitsOfWork.size(); ++i) {
            NestableUnitOfWork unitOfWork = this.innerUnitsOfWork.get(i);
            if (!unitOfWork.isStarted()) continue;
            unitOfWork.performInnerCommit();
        }
    }

    private void registerInnerUnitOfWork(NestableUnitOfWork unitOfWork) {
        if (this.outerUnitOfWork instanceof NestableUnitOfWork) {
            ((NestableUnitOfWork)this.outerUnitOfWork).registerInnerUnitOfWork(unitOfWork);
        } else {
            this.innerUnitsOfWork.add(unitOfWork);
        }
    }

    protected abstract void saveAggregates();

    protected abstract void notifyListenersPrepareCommit();

    @Override
    public void attachResource(String name, Object resource) {
        this.resources.put(name, resource);
        this.inheritedResources.remove(name);
    }

    @Override
    public void attachResource(String name, Object resource, boolean inherited) {
        this.resources.put(name, resource);
        if (inherited) {
            this.inheritedResources.put(name, resource);
        } else {
            this.inheritedResources.remove(name);
        }
    }

    @Override
    public <T> T getResource(String name) {
        return (T)this.resources.get(name);
    }

    @Override
    public void attachInheritedResources(UnitOfWork inheritingUnitOfWork) {
        for (Map.Entry<String, Object> entry : this.inheritedResources.entrySet()) {
            inheritingUnitOfWork.attachResource(entry.getKey(), entry.getValue(), true);
        }
    }

    private final class CommitOnOuterCommitTask
    extends UnitOfWorkListenerAdapter {
        private CommitOnOuterCommitTask() {
        }

        @Override
        public void afterCommit(UnitOfWork unitOfWork) {
            NestableUnitOfWork.this.performInnerCommit();
        }

        @Override
        public void onRollback(UnitOfWork unitOfWork, Throwable failureCause) {
            CurrentUnitOfWork.set(NestableUnitOfWork.this);
            NestableUnitOfWork.this.rollback(failureCause);
        }

        @Override
        public void onCleanup(UnitOfWork unitOfWork) {
            NestableUnitOfWork.this.performCleanup();
        }
    }
}

