/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.unitofwork;

import java.util.Deque;
import java.util.LinkedList;
import org.axonframework.unitofwork.UnitOfWork;

public abstract class CurrentUnitOfWork {
    private static final ThreadLocal<Deque<UnitOfWork>> CURRENT = new ThreadLocal();

    private CurrentUnitOfWork() {
    }

    public static boolean isStarted() {
        return CURRENT.get() != null && !CURRENT.get().isEmpty();
    }

    public static UnitOfWork get() {
        if (CurrentUnitOfWork.isEmpty()) {
            throw new IllegalStateException("No UnitOfWork is currently started for this thread.");
        }
        return CURRENT.get().peek();
    }

    private static boolean isEmpty() {
        Deque<UnitOfWork> unitsOfWork = CURRENT.get();
        return unitsOfWork == null || unitsOfWork.isEmpty();
    }

    public static void commit() {
        CurrentUnitOfWork.get().commit();
    }

    public static void set(UnitOfWork unitOfWork) {
        if (CURRENT.get() == null) {
            CURRENT.set(new LinkedList());
        }
        CURRENT.get().push(unitOfWork);
    }

    public static void clear(UnitOfWork unitOfWork) {
        if (CurrentUnitOfWork.isStarted() && CURRENT.get().peek() == unitOfWork) {
            CURRENT.get().pop();
            if (CURRENT.get().isEmpty()) {
                CURRENT.remove();
            }
        } else {
            throw new IllegalStateException("Could not clear this UnitOfWork. It is not the active one.");
        }
    }
}

