/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.serializer.xml;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.xml.Dom4JReader;
import com.thoughtworks.xstream.io.xml.XomReader;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import nu.xom.Document;
import org.axonframework.serializer.AbstractXStreamSerializer;
import org.axonframework.serializer.ChainingConverterFactory;
import org.axonframework.serializer.ConverterFactory;
import org.axonframework.serializer.RevisionResolver;
import org.axonframework.serializer.SerializedObject;
import org.axonframework.serializer.xml.CompactDriver;
import org.axonframework.serializer.xml.Dom4JToByteArrayConverter;
import org.axonframework.serializer.xml.InputStreamToDom4jConverter;
import org.axonframework.serializer.xml.InputStreamToXomConverter;
import org.axonframework.serializer.xml.XomToStringConverter;

public class XStreamSerializer
extends AbstractXStreamSerializer {
    public XStreamSerializer() {
        super(new XStream((HierarchicalStreamDriver)new CompactDriver()));
    }

    public XStreamSerializer(RevisionResolver revisionResolver) {
        this(new XStream((HierarchicalStreamDriver)new CompactDriver()), revisionResolver);
    }

    public XStreamSerializer(XStream xStream) {
        super(xStream);
    }

    public XStreamSerializer(XStream xStream, RevisionResolver revisionResolver) {
        super(xStream, revisionResolver);
    }

    public XStreamSerializer(Charset charset) {
        super(charset, new XStream((HierarchicalStreamDriver)new CompactDriver()));
    }

    public XStreamSerializer(Charset charset, XStream xStream, RevisionResolver revisionResolver) {
        super(charset, xStream, revisionResolver);
    }

    public XStreamSerializer(Charset charset, XStream xStream, RevisionResolver revisionResolver, ConverterFactory converterFactory) {
        super(charset, xStream, revisionResolver, converterFactory);
    }

    @Override
    protected <T> T doSerialize(Object object, Class<T> expectedFormat, XStream xStream) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        xStream.toXML(object, (Writer)new OutputStreamWriter((OutputStream)baos, this.getCharset()));
        return this.convert(byte[].class, expectedFormat, baos.toByteArray());
    }

    @Override
    public Object doDeserialize(SerializedObject serializedObject, XStream xStream) {
        if ("org.dom4j.Document".equals(serializedObject.getContentType().getName())) {
            return xStream.unmarshal((HierarchicalStreamReader)new Dom4JReader((org.dom4j.Document)serializedObject.getData()));
        }
        if ("nu.xom.Document".equals(serializedObject.getContentType().getName())) {
            return xStream.unmarshal((HierarchicalStreamReader)new XomReader((Document)serializedObject.getData()));
        }
        InputStream serializedData = this.convert(serializedObject.getContentType(), InputStream.class, serializedObject.getData());
        return xStream.fromXML((Reader)new InputStreamReader(serializedData, this.getCharset()));
    }

    @Override
    protected void registerConverters(ChainingConverterFactory converterFactory) {
        converterFactory.registerConverter(Dom4JToByteArrayConverter.class);
        converterFactory.registerConverter(InputStreamToDom4jConverter.class);
        converterFactory.registerConverter(XomToStringConverter.class);
        converterFactory.registerConverter(InputStreamToXomConverter.class);
    }
}

