/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.serializer.converters;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.axonframework.serializer.AbstractContentTypeConverter;
import org.axonframework.serializer.CannotConvertBetweenTypesException;

public class InputStreamToByteArrayConverter
extends AbstractContentTypeConverter<InputStream, byte[]> {
    @Override
    public Class<InputStream> expectedSourceType() {
        return InputStream.class;
    }

    @Override
    public Class<byte[]> targetType() {
        return byte[].class;
    }

    @Override
    public byte[] convert(InputStream original) {
        try {
            return this.bytesFrom(original);
        }
        catch (IOException e) {
            throw new CannotConvertBetweenTypesException("Unable to convert InputStream to byte[]. Error while reading from Stream.", e);
        }
    }

    private byte[] bytesFrom(InputStream original) throws IOException {
        int n;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while (-1 != (n = original.read(buffer))) {
            output.write(buffer, 0, n);
        }
        return output.toByteArray();
    }
}

