/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.serializer;

import org.axonframework.domain.MetaData;
import org.axonframework.serializer.SerializedObject;
import org.axonframework.serializer.SerializedType;
import org.axonframework.serializer.SimpleSerializedObject;

public class SerializedMetaData<T>
implements SerializedObject<T> {
    private static final String METADATA_CLASS_NAME = MetaData.class.getName();
    private final SimpleSerializedObject<T> delegate;

    public SerializedMetaData(T data, Class<T> dataType) {
        this.delegate = new SimpleSerializedObject<T>(data, dataType, METADATA_CLASS_NAME, null);
    }

    public static boolean isSerializedMetaData(SerializedObject<?> serializedObject) {
        return serializedObject != null && serializedObject.getType() != null && METADATA_CLASS_NAME.equals(serializedObject.getType().getName());
    }

    @Override
    public T getData() {
        return this.delegate.getData();
    }

    @Override
    public Class<T> getContentType() {
        return this.delegate.getContentType();
    }

    @Override
    public SerializedType getType() {
        return this.delegate.getType();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SerializedMetaData that = (SerializedMetaData)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }
}

