/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.serializer;

import java.util.Map;
import org.axonframework.domain.GenericMessage;
import org.axonframework.domain.Message;
import org.axonframework.domain.MetaData;
import org.axonframework.serializer.ChainingConverterFactory;
import org.axonframework.serializer.ConverterFactory;
import org.axonframework.serializer.LazyDeserializingObject;
import org.axonframework.serializer.SerializationAware;
import org.axonframework.serializer.SerializedObject;
import org.axonframework.serializer.Serializer;

public class SerializedMessage<T>
implements Message<T>,
SerializationAware {
    private static final long serialVersionUID = 6332429891815042291L;
    private static final ConverterFactory CONVERTER_FACTORY = new ChainingConverterFactory();
    private final String identifier;
    private final LazyDeserializingObject<MetaData> serializedMetaData;
    private final LazyDeserializingObject<T> serializedPayload;

    public SerializedMessage(String identifier, SerializedObject<?> serializedPayload, SerializedObject<?> serializedMetaData, Serializer serializer) {
        this.identifier = identifier;
        this.serializedMetaData = new LazyDeserializingObject(serializedMetaData, serializer);
        this.serializedPayload = new LazyDeserializingObject(serializedPayload, serializer);
    }

    private SerializedMessage(SerializedMessage<T> message, Map<String, ?> metaData) {
        this.identifier = message.getIdentifier();
        this.serializedMetaData = new LazyDeserializingObject<MetaData>(MetaData.from(metaData));
        this.serializedPayload = message.serializedPayload;
    }

    public <R> SerializedObject<R> serializePayload(Serializer serializer, Class<R> expectedRepresentation) {
        if (serializer.equals(this.serializedPayload.getSerializer())) {
            SerializedObject<?> serializedObject = this.serializedPayload.getSerializedObject();
            return CONVERTER_FACTORY.getConverter(serializedObject.getContentType(), expectedRepresentation).convert(serializedObject);
        }
        return serializer.serialize(this.serializedPayload.getObject(), expectedRepresentation);
    }

    public <R> SerializedObject<R> serializeMetaData(Serializer serializer, Class<R> expectedRepresentation) {
        if (serializer.equals(this.serializedMetaData.getSerializer())) {
            SerializedObject<?> serializedObject = this.serializedMetaData.getSerializedObject();
            return CONVERTER_FACTORY.getConverter(serializedObject.getContentType(), expectedRepresentation).convert(serializedObject);
        }
        return serializer.serialize(this.serializedMetaData.getObject(), expectedRepresentation);
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public MetaData getMetaData() {
        MetaData metaData = this.serializedMetaData.getObject();
        return metaData == null ? MetaData.emptyInstance() : metaData;
    }

    @Override
    public T getPayload() {
        return this.serializedPayload.getObject();
    }

    @Override
    public Class getPayloadType() {
        return this.serializedPayload.getType();
    }

    @Override
    public SerializedMessage<T> withMetaData(Map<String, ?> metaData) {
        if (this.serializedMetaData.getObject().equals(metaData)) {
            return this;
        }
        return new SerializedMessage<T>(this, metaData);
    }

    @Override
    public SerializedMessage<T> andMetaData(Map<String, ?> metaData) {
        if (metaData.isEmpty()) {
            return this;
        }
        return new SerializedMessage<T>(this, this.getMetaData().mergedWith(metaData));
    }

    public boolean isPayloadDeserialized() {
        return this.serializedPayload.isDeserialized();
    }

    protected Object writeReplace() {
        return new GenericMessage<T>(this.identifier, this.getPayload(), this.getMetaData());
    }
}

