/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.serializer;

import java.util.Map;
import org.axonframework.domain.DomainEventMessage;
import org.axonframework.domain.GenericDomainEventMessage;
import org.axonframework.domain.MetaData;
import org.axonframework.serializer.SerializationAware;
import org.axonframework.serializer.SerializedDomainEventData;
import org.axonframework.serializer.SerializedEventMessage;
import org.axonframework.serializer.SerializedObject;
import org.axonframework.serializer.Serializer;
import org.joda.time.DateTime;

public class SerializedDomainEventMessage<T>
implements DomainEventMessage<T>,
SerializationAware {
    private static final long serialVersionUID = 1946981128830316529L;
    private final long sequenceNumber;
    private final Object aggregateIdentifier;
    private final SerializedEventMessage<T> eventMessage;

    public SerializedDomainEventMessage(SerializedDomainEventData domainEventData, Serializer serializer) {
        this.eventMessage = new SerializedEventMessage(domainEventData.getEventIdentifier(), domainEventData.getTimestamp(), domainEventData.getPayload(), domainEventData.getMetaData(), serializer);
        this.aggregateIdentifier = domainEventData.getAggregateIdentifier();
        this.sequenceNumber = domainEventData.getSequenceNumber();
    }

    public SerializedDomainEventMessage(SerializedEventMessage<T> eventMessage, Object aggregateIdentifier, long sequenceNumber) {
        this.eventMessage = eventMessage;
        this.aggregateIdentifier = aggregateIdentifier;
        this.sequenceNumber = sequenceNumber;
    }

    private SerializedDomainEventMessage(SerializedDomainEventMessage<T> original, Map<String, ?> metaData) {
        this.eventMessage = original.eventMessage.withMetaData((Map)metaData);
        this.aggregateIdentifier = original.getAggregateIdentifier();
        this.sequenceNumber = original.getSequenceNumber();
    }

    public <R> SerializedObject<R> serializePayload(Serializer serializer, Class<R> expectedRepresentation) {
        return this.eventMessage.serializePayload(serializer, expectedRepresentation);
    }

    public <R> SerializedObject<R> serializeMetaData(Serializer serializer, Class<R> expectedRepresentation) {
        return this.eventMessage.serializeMetaData(serializer, expectedRepresentation);
    }

    @Override
    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    @Override
    public Object getAggregateIdentifier() {
        return this.aggregateIdentifier;
    }

    @Override
    public DomainEventMessage<T> withMetaData(Map<String, ?> newMetaData) {
        if (this.eventMessage.isPayloadDeserialized()) {
            return new GenericDomainEventMessage<T>(this.getIdentifier(), this.getTimestamp(), this.aggregateIdentifier, this.sequenceNumber, this.getPayload(), newMetaData);
        }
        return new SerializedDomainEventMessage<T>(this, newMetaData);
    }

    @Override
    public DomainEventMessage<T> andMetaData(Map<String, ?> additionalMetaData) {
        MetaData newMetaData = this.getMetaData().mergedWith(additionalMetaData);
        return this.withMetaData((Map)newMetaData);
    }

    @Override
    public Class getPayloadType() {
        return this.eventMessage.getPayloadType();
    }

    @Override
    public T getPayload() {
        return this.eventMessage.getPayload();
    }

    @Override
    public MetaData getMetaData() {
        return this.eventMessage.getMetaData();
    }

    @Override
    public DateTime getTimestamp() {
        return this.eventMessage.getTimestamp();
    }

    @Override
    public String getIdentifier() {
        return this.eventMessage.getIdentifier();
    }

    public boolean isPayloadDeserialized() {
        return this.eventMessage.isPayloadDeserialized();
    }

    protected Object writeReplace() {
        return new GenericDomainEventMessage<T>(this.getIdentifier(), this.getTimestamp(), this.getAggregateIdentifier(), this.getSequenceNumber(), this.getPayload(), this.getMetaData());
    }
}

