/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.serializer;

import java.util.Map;
import org.axonframework.domain.EventMessage;
import org.axonframework.domain.MetaData;
import org.axonframework.serializer.SerializationAware;
import org.axonframework.serializer.SerializedObject;
import org.axonframework.serializer.SerializedObjectHolder;
import org.axonframework.serializer.Serializer;
import org.joda.time.DateTime;

public class SerializationAwareEventMessage<T>
implements SerializationAware,
EventMessage<T> {
    private static final long serialVersionUID = 4760330133615704145L;
    private final EventMessage<T> eventMessage;
    private final SerializedObjectHolder serializedObjectHolder;

    public static <T> EventMessage<T> wrap(EventMessage<T> message) {
        if (message instanceof SerializationAware) {
            return message;
        }
        return new SerializationAwareEventMessage<T>(message);
    }

    protected SerializationAwareEventMessage(EventMessage<T> eventMessage) {
        this.eventMessage = eventMessage;
        this.serializedObjectHolder = new SerializedObjectHolder(eventMessage);
    }

    @Override
    public String getIdentifier() {
        return this.eventMessage.getIdentifier();
    }

    @Override
    public MetaData getMetaData() {
        return this.eventMessage.getMetaData();
    }

    @Override
    public T getPayload() {
        return this.eventMessage.getPayload();
    }

    @Override
    public Class getPayloadType() {
        return this.eventMessage.getPayloadType();
    }

    @Override
    public DateTime getTimestamp() {
        return this.eventMessage.getTimestamp();
    }

    @Override
    public EventMessage<T> withMetaData(Map<String, ?> metaData) {
        EventMessage<T> newMessage = this.eventMessage.withMetaData(metaData);
        if (this.eventMessage == newMessage) {
            return this;
        }
        return new SerializationAwareEventMessage<T>(newMessage);
    }

    @Override
    public EventMessage<T> andMetaData(Map<String, ?> metaData) {
        EventMessage<T> newMessage = this.eventMessage.andMetaData(metaData);
        if (this.eventMessage == newMessage) {
            return this;
        }
        return new SerializationAwareEventMessage<T>(newMessage);
    }

    public <R> SerializedObject<R> serializePayload(Serializer serializer, Class<R> expectedRepresentation) {
        return this.serializedObjectHolder.serializePayload(serializer, expectedRepresentation);
    }

    public <R> SerializedObject<R> serializeMetaData(Serializer serializer, Class<R> expectedRepresentation) {
        return this.serializedObjectHolder.serializeMetaData(serializer, expectedRepresentation);
    }

    protected Object writeReplace() {
        return this.eventMessage;
    }
}

