/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.serializer;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.axonframework.common.io.IOUtils;
import org.axonframework.serializer.RevisionResolver;

public class MavenArtifactRevisionResolver
implements RevisionResolver {
    private final String version;

    public MavenArtifactRevisionResolver(String groupId, String artifactId) throws IOException {
        this(groupId, artifactId, MavenArtifactRevisionResolver.class.getClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MavenArtifactRevisionResolver(String groupId, String artifactId, ClassLoader classLoader) throws IOException {
        InputStream propFile = classLoader.getResourceAsStream("META-INF/maven/" + groupId + "/" + artifactId + "/pom.properties");
        if (propFile != null) {
            try {
                Properties mavenProps = new Properties();
                mavenProps.load(propFile);
                this.version = mavenProps.getProperty("version");
            }
            finally {
                IOUtils.closeQuietly(propFile);
            }
        } else {
            this.version = null;
        }
    }

    @Override
    public String revisionOf(Class<?> payloadType) {
        return this.version;
    }
}

