/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.serializer;

import org.axonframework.common.Assert;
import org.axonframework.serializer.SerializedObject;
import org.axonframework.serializer.Serializer;

public class LazyDeserializingObject<T> {
    private final Serializer serializer;
    private final SerializedObject<?> serializedObject;
    private final Class<?> deserializedObjectType;
    private volatile T deserializedObject;

    public LazyDeserializingObject(T deserializedObject) {
        Assert.notNull(deserializedObject, "The given deserialized instance may not be null");
        this.serializedObject = null;
        this.serializer = null;
        this.deserializedObject = deserializedObject;
        this.deserializedObjectType = deserializedObject.getClass();
    }

    public LazyDeserializingObject(SerializedObject<?> serializedObject, Serializer serializer) {
        Assert.notNull(serializedObject, "The given serializedObject may not be null");
        Assert.notNull(serializer, "The given serializer may not be null");
        this.serializedObject = serializedObject;
        this.serializer = serializer;
        this.deserializedObjectType = serializer.classForType(serializedObject.getType());
    }

    public Class<?> getType() {
        return this.deserializedObjectType;
    }

    public T getObject() {
        if (!this.isDeserialized()) {
            this.deserializedObject = this.serializer.deserialize(this.serializedObject);
        }
        return this.deserializedObject;
    }

    public boolean isDeserialized() {
        return this.deserializedObject != null;
    }

    public Serializer getSerializer() {
        return this.serializer;
    }

    public SerializedObject<?> getSerializedObject() {
        return this.serializedObject;
    }
}

