/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.serializer;

import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.CopyOnWriteArrayList;
import org.axonframework.serializer.ChainedConverter;
import org.axonframework.serializer.ContentTypeConverter;
import org.axonframework.serializer.ConverterFactory;
import org.axonframework.serializer.SerializedObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChainingConverterFactory
implements ConverterFactory {
    private static final Logger logger = LoggerFactory.getLogger(ChainingConverterFactory.class);
    private final List<ContentTypeConverter<?, ?>> converters = new CopyOnWriteArrayList();

    public ChainingConverterFactory() {
        ServiceLoader<ContentTypeConverter> converterLoader = ServiceLoader.load(ContentTypeConverter.class);
        for (ContentTypeConverter converter : converterLoader) {
            this.converters.add(converter);
        }
    }

    @Override
    public <S, T> boolean hasConverter(Class<S> sourceContentType, Class<T> targetContentType) {
        if (sourceContentType.equals(targetContentType)) {
            return true;
        }
        for (ContentTypeConverter<?, ?> converter : this.converters) {
            if (!this.canConvert(converter, sourceContentType, targetContentType)) continue;
            return true;
        }
        return ChainedConverter.canConvert(sourceContentType, targetContentType, this.converters);
    }

    @Override
    public <S, T> ContentTypeConverter<S, T> getConverter(Class<S> sourceContentType, Class<T> targetContentType) {
        if (sourceContentType.equals(targetContentType)) {
            return new NoConversion<S>(sourceContentType);
        }
        for (ContentTypeConverter<?, ?> converter : this.converters) {
            if (!this.canConvert(converter, sourceContentType, targetContentType)) continue;
            return converter;
        }
        ChainedConverter<S, T> converter = ChainedConverter.calculateChain(sourceContentType, targetContentType, this.converters);
        this.converters.add(0, converter);
        return converter;
    }

    private <S, T> boolean canConvert(ContentTypeConverter<?, ?> converter, Class<S> sourceContentType, Class<T> targetContentType) {
        try {
            if (converter.expectedSourceType().isAssignableFrom(sourceContentType) && targetContentType.isAssignableFrom(converter.targetType())) {
                return true;
            }
            converter.targetType();
        }
        catch (NoClassDefFoundError e) {
            logger.info("ContentTypeConverter [{}] is ignored. It seems to rely on a class that is not available in the class loader: {}", converter, (Object)e.getMessage());
            this.converters.remove(converter);
        }
        return false;
    }

    public void registerConverter(ContentTypeConverter converter) {
        this.converters.add(0, converter);
    }

    public void registerConverter(Class<? extends ContentTypeConverter> converterType) {
        try {
            ContentTypeConverter converter = converterType.getConstructor(new Class[0]).newInstance(new Object[0]);
            converter.targetType();
            converter.expectedSourceType();
            this.registerConverter(converter);
        }
        catch (Exception e) {
            logger.warn("An exception occurred while trying to initialize a [{}].", (Object)converterType.getName(), (Object)e);
        }
        catch (NoClassDefFoundError e) {
            logger.info("ContentTypeConverter of type [{}] is ignored. It seems to rely on a class that is not available in the class loader: {}", converterType, (Object)e.getMessage());
        }
    }

    public void setAdditionalConverters(List<ContentTypeConverter> additionalConverters) {
        for (ContentTypeConverter converter : additionalConverters) {
            this.registerConverter(converter);
        }
    }

    private static class NoConversion<T>
    implements ContentTypeConverter<T, T> {
        private final Class<T> type;

        public NoConversion(Class<T> type) {
            this.type = type;
        }

        @Override
        public Class<T> expectedSourceType() {
            return this.type;
        }

        @Override
        public Class<T> targetType() {
            return this.type;
        }

        @Override
        public SerializedObject<T> convert(SerializedObject<T> original) {
            return original;
        }

        @Override
        public T convert(T original) {
            return original;
        }
    }
}

