/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.saga.repository.jdbc;

import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Set;
import java.util.TreeSet;
import javax.sql.DataSource;
import org.axonframework.common.jdbc.ConnectionProvider;
import org.axonframework.common.jdbc.DataSourceConnectionProvider;
import org.axonframework.common.jdbc.JdbcUtils;
import org.axonframework.common.jdbc.UnitOfWorkAwareConnectionProviderWrapper;
import org.axonframework.saga.AssociationValue;
import org.axonframework.saga.ResourceInjector;
import org.axonframework.saga.Saga;
import org.axonframework.saga.SagaStorageException;
import org.axonframework.saga.repository.AbstractSagaRepository;
import org.axonframework.saga.repository.jdbc.GenericSagaSqlSchema;
import org.axonframework.saga.repository.jdbc.SagaSqlSchema;
import org.axonframework.saga.repository.jpa.SagaEntry;
import org.axonframework.serializer.SerializedObject;
import org.axonframework.serializer.Serializer;
import org.axonframework.serializer.xml.XStreamSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcSagaRepository
extends AbstractSagaRepository {
    private static final Logger logger = LoggerFactory.getLogger(JdbcSagaRepository.class);
    private ResourceInjector injector;
    private Serializer serializer;
    private final ConnectionProvider connectionProvider;
    private final SagaSqlSchema sqldef;

    public JdbcSagaRepository(ConnectionProvider connectionProvider) {
        this(connectionProvider, (SagaSqlSchema)new GenericSagaSqlSchema());
    }

    public JdbcSagaRepository(DataSource dataSource, SagaSqlSchema sqldef) {
        this(new UnitOfWorkAwareConnectionProviderWrapper(new DataSourceConnectionProvider(dataSource)), sqldef);
    }

    public JdbcSagaRepository(ConnectionProvider connectionProvider, SagaSqlSchema sqldef) {
        this(connectionProvider, sqldef, new XStreamSerializer());
    }

    public JdbcSagaRepository(ConnectionProvider connectionProvider, SagaSqlSchema sqldef, Serializer serializer) {
        this.connectionProvider = connectionProvider;
        this.sqldef = sqldef;
        this.serializer = serializer;
    }

    @Override
    public Saga load(String sagaId) {
        Saga saga;
        SerializedObject<?> serializedSaga;
        Connection conn;
        ResultSet resultSet;
        PreparedStatement statement;
        block8: {
            statement = null;
            resultSet = null;
            conn = null;
            conn = this.connectionProvider.getConnection();
            statement = this.sqldef.sql_loadSaga(conn, sagaId);
            resultSet = statement.executeQuery();
            serializedSaga = null;
            if (resultSet.next()) {
                serializedSaga = this.sqldef.readSerializedSaga(resultSet);
            }
            if (serializedSaga != null) break block8;
            Saga saga2 = null;
            JdbcUtils.closeQuietly(statement);
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly(conn);
            return saga2;
        }
        try {
            Saga loadedSaga = (Saga)this.serializer.deserialize(serializedSaga);
            if (this.injector != null) {
                this.injector.injectResources(loadedSaga);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Loaded saga id [{}] of type [{}]", (Object)sagaId, (Object)loadedSaga.getClass().getName());
            }
            saga = loadedSaga;
        }
        catch (SQLException e) {
            try {
                throw new SagaStorageException("Exception while loading a Saga", e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(statement);
                JdbcUtils.closeQuietly(resultSet);
                JdbcUtils.closeQuietly(conn);
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly(statement);
        JdbcUtils.closeQuietly(resultSet);
        JdbcUtils.closeQuietly(conn);
        return saga;
    }

    @Override
    protected void removeAssociationValue(AssociationValue associationValue, String sagaType, String sagaIdentifier) {
        Connection conn = null;
        try {
            conn = this.connectionProvider.getConnection();
            PreparedStatement preparedStatement = this.sqldef.sql_removeAssocValue(conn, associationValue.getKey(), associationValue.getValue(), sagaType, sagaIdentifier);
            int updateCount = preparedStatement.executeUpdate();
            if (updateCount == 0 && logger.isWarnEnabled()) {
                logger.warn("Wanted to remove association value, but it was already gone: sagaId= {}, key={}, value={}", new Object[]{sagaIdentifier, associationValue.getKey(), associationValue.getValue()});
            }
        }
        catch (SQLException e) {
            throw new SagaStorageException("Exception occurred while attempting to remove an AssociationValue", e);
        }
        finally {
            JdbcUtils.closeQuietly(conn);
        }
    }

    @Override
    protected String typeOf(Class<? extends Saga> sagaClass) {
        return this.serializer.typeForClass(sagaClass).getName();
    }

    @Override
    protected void storeAssociationValue(AssociationValue associationValue, String sagaType, String sagaIdentifier) {
        PreparedStatement statement = null;
        Connection conn = null;
        try {
            conn = this.connectionProvider.getConnection();
            statement = this.sqldef.sql_storeAssocValue(conn, associationValue.getKey(), associationValue.getValue(), sagaType, sagaIdentifier);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new SagaStorageException("Exception while storing an association value", e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(statement);
                JdbcUtils.closeQuietly(conn);
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly(statement);
        JdbcUtils.closeQuietly(conn);
    }

    @Override
    protected Set<String> findAssociatedSagaIdentifiers(Class<? extends Saga> type, AssociationValue associationValue) {
        TreeSet<String> treeSet;
        ResultSet resultSet = null;
        PreparedStatement statement = null;
        Connection conn = null;
        try {
            conn = this.connectionProvider.getConnection();
            statement = this.sqldef.sql_findAssocSagaIdentifiers(conn, associationValue.getKey(), associationValue.getValue(), this.typeOf(type));
            resultSet = statement.executeQuery();
            TreeSet<String> result = new TreeSet<String>();
            while (resultSet.next()) {
                result.add(resultSet.getString(1));
            }
            treeSet = result;
        }
        catch (SQLException e) {
            try {
                throw new SagaStorageException("Exception while reading saga associations", e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(statement);
                JdbcUtils.closeQuietly(resultSet);
                JdbcUtils.closeQuietly(conn);
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly(statement);
        JdbcUtils.closeQuietly(resultSet);
        JdbcUtils.closeQuietly(conn);
        return treeSet;
    }

    @Override
    protected void deleteSaga(Saga saga) {
        PreparedStatement statement1 = null;
        PreparedStatement statement2 = null;
        Connection conn = null;
        try {
            conn = this.connectionProvider.getConnection();
            statement1 = this.sqldef.sql_deleteAssociationEntries(conn, saga.getSagaIdentifier());
            statement2 = this.sqldef.sql_deleteSagaEntry(conn, saga.getSagaIdentifier());
            statement1.executeUpdate();
            statement2.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new SagaStorageException("Exception occurred while attempting to delete a saga entry", e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(statement1);
                JdbcUtils.closeQuietly(statement2);
                JdbcUtils.closeQuietly(conn);
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly(statement1);
        JdbcUtils.closeQuietly(statement2);
        JdbcUtils.closeQuietly(conn);
    }

    @Override
    protected void updateSaga(Saga saga) {
        SagaEntry entry = new SagaEntry(saga, this.serializer);
        if (logger.isDebugEnabled()) {
            logger.debug("Updating saga id {} as {}", (Object)saga.getSagaIdentifier(), (Object)new String(entry.getSerializedSaga(), Charset.forName("UTF-8")));
        }
        int updateCount = 0;
        PreparedStatement statement = null;
        Connection conn = null;
        try {
            conn = this.connectionProvider.getConnection();
            statement = this.sqldef.sql_updateSaga(conn, entry.getSagaId(), entry.getSerializedSaga(), entry.getSagaType(), entry.getRevision());
            updateCount = statement.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new SagaStorageException("Exception occurred while attempting to update a saga", e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(statement);
                JdbcUtils.closeQuietly(conn);
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly(statement);
        JdbcUtils.closeQuietly(conn);
        if (updateCount == 0) {
            logger.warn("Expected to be able to update a Saga instance, but no rows were found. Inserting instead.");
            this.storeSaga(saga);
        }
    }

    @Override
    protected void storeSaga(Saga saga) {
        SagaEntry entry = new SagaEntry(saga, this.serializer);
        if (logger.isDebugEnabled()) {
            logger.debug("Storing saga id {} as {}", (Object)saga.getSagaIdentifier(), (Object)new String(entry.getSerializedSaga(), Charset.forName("UTF-8")));
        }
        Connection conn = null;
        PreparedStatement statement = null;
        try {
            conn = this.connectionProvider.getConnection();
            statement = this.sqldef.sql_storeSaga(conn, entry.getSagaId(), entry.getRevision(), entry.getSagaType(), entry.getSerializedSaga());
            statement.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new SagaStorageException("Exception occurred while attempting to store a Saga Entry", e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(statement);
                JdbcUtils.closeQuietly(conn);
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly(statement);
        JdbcUtils.closeQuietly(conn);
    }

    public void setResourceInjector(ResourceInjector resourceInjector) {
        this.injector = resourceInjector;
    }

    public void setSerializer(Serializer serializer) {
        this.serializer = serializer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSchema() throws SQLException {
        Connection connection = this.connectionProvider.getConnection();
        try {
            this.sqldef.sql_createTableSagaEntry(connection).executeUpdate();
            this.sqldef.sql_createTableAssocValueEntry(connection).executeUpdate();
        }
        finally {
            JdbcUtils.closeQuietly(connection);
        }
    }
}

